/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.io.FileWriteMode;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import restx.RestxContext;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRouter;
import restx.StdRestxRequestMatcher;
import restx.StdRoute;
import restx.WebException;
import restx.http.HTTP;
import restx.http.HttpStatus;

public class FSRouter {
    private String fsPath;
    private boolean readonly;
    private boolean allowDirectoryListing;

    public static FSRouter mount(String fsPath) {
        return new FSRouter(fsPath);
    }

    private FSRouter(String fsPath) {
        this.fsPath = fsPath;
    }

    public RestxRouter on(String onPath) {
        if (!onPath.endsWith("/")) {
            onPath = onPath + "/";
        }
        final Path root = Paths.get(this.fsPath, new String[0]);
        RestxRouter.Builder builder = RestxRouter.builder().name("FS:" + this.fsPath).addRoute(new StdRoute("FS:GET:" + this.fsPath, new StdRestxRequestMatcher("GET", onPath + "{path:.*}")){

            @Override
            public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                String path = match.getPathParam("path");
                File file = root.resolve(path).toFile();
                if (!file.exists()) {
                    this.notFound(match, resp);
                    return;
                }
                if (file.isFile()) {
                    resp.setStatus(HttpStatus.OK);
                    resp.setContentType((String)HTTP.getContentTypeFromExtension(file.getName()).or((Object)"application/binary"));
                    com.google.common.io.Files.asByteSource((File)file).copyTo(resp.getOutputStream());
                } else if (file.isDirectory() && FSRouter.this.allowDirectoryListing) {
                    resp.setStatus(HttpStatus.OK);
                    resp.setContentType("application/json");
                    PrintWriter writer = resp.getWriter();
                    writer.println("[");
                    Path dir = file.toPath();
                    Iterator<Path> iterator = Files.newDirectoryStream(dir).iterator();
                    while (iterator.hasNext()) {
                        Path s = iterator.next();
                        boolean isDirectory = s.toFile().isDirectory();
                        writer.println("\"" + dir.relativize(s) + (isDirectory ? "/" : "") + "\"" + (iterator.hasNext() ? "," : "") + "");
                    }
                    writer.println("]");
                } else {
                    throw new WebException(HttpStatus.UNAUTHORIZED);
                }
            }

            @Override
            public String toString() {
                return this.getMatcher().toString() + " => FS:" + root.toFile().getAbsolutePath();
            }
        });
        if (!this.readonly) {
            builder.addRoute(new StdRoute("FS:PUT:" + this.fsPath, new StdRestxRequestMatcher("PUT", onPath + "{path:.*}")){

                @Override
                public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                    String path = match.getPathParam("path");
                    File file = root.resolve(path).toFile();
                    if (file.exists() && !file.isFile()) {
                        throw new WebException(HttpStatus.UNAUTHORIZED);
                    }
                    if (path.endsWith("/")) {
                        if (!file.mkdirs()) {
                            throw new WebException(HttpStatus.UNAUTHORIZED);
                        }
                        resp.setStatus(HttpStatus.CREATED);
                        return;
                    }
                    if (!file.exists()) {
                        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                            throw new WebException(HttpStatus.UNAUTHORIZED);
                        }
                        com.google.common.io.Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).writeFrom(req.getContentStream());
                        resp.setStatus(HttpStatus.CREATED);
                    } else {
                        com.google.common.io.Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).writeFrom(req.getContentStream());
                        resp.setStatus(HttpStatus.ACCEPTED);
                    }
                }

                @Override
                public String toString() {
                    return this.getMatcher().toString() + " => FS:" + root.toFile().getAbsolutePath();
                }
            });
            builder.addRoute(new StdRoute("FS:DELETE:" + this.fsPath, new StdRestxRequestMatcher("DELETE", onPath + "{path:.*}")){

                @Override
                public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                    String path = match.getPathParam("path");
                    File file = root.resolve(path).toFile();
                    if (!file.exists()) {
                        resp.setStatus(HttpStatus.NO_CONTENT);
                        return;
                    }
                    if (file.isDirectory() && file.list().length > 0) {
                        throw new WebException(HttpStatus.UNAUTHORIZED, "can't delete non empty directory");
                    }
                    Files.delete(file.toPath());
                    resp.setStatus(HttpStatus.NO_CONTENT);
                }

                @Override
                public String toString() {
                    return this.getMatcher().toString() + " => FS:" + root.toFile().getAbsolutePath();
                }
            });
        }
        return builder.build();
    }

    public FSRouter readonly() {
        this.readonly = true;
        return this;
    }

    public FSRouter allowDirectoryListing() {
        this.allowDirectoryListing = true;
        return this;
    }
}

