/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.exceptions;

import io.reactivex.rxjava3.annotations.NonNull;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public final class CompositeException
extends RuntimeException {
    private static final long serialVersionUID = 3026362227162912146L;
    private final List<Throwable> exceptions;
    private final String message;
    private Throwable cause;

    public CompositeException(Throwable ... exceptions) {
        this(exceptions == null ? Collections.singletonList(new NullPointerException("exceptions was null")) : Arrays.asList(exceptions));
    }

    public CompositeException(@NonNull Iterable<? extends Throwable> errors) {
        LinkedHashSet<Throwable> deDupedExceptions = new LinkedHashSet<Throwable>();
        ArrayList<Throwable> localExceptions = new ArrayList<Throwable>();
        if (errors != null) {
            for (Throwable throwable : errors) {
                if (throwable instanceof CompositeException) {
                    deDupedExceptions.addAll(((CompositeException)throwable).getExceptions());
                    continue;
                }
                if (throwable != null) {
                    deDupedExceptions.add(throwable);
                    continue;
                }
                deDupedExceptions.add(new NullPointerException("Throwable was null!"));
            }
        } else {
            deDupedExceptions.add(new NullPointerException("errors was null"));
        }
        if (deDupedExceptions.isEmpty()) {
            throw new IllegalArgumentException("errors is empty");
        }
        localExceptions.addAll(deDupedExceptions);
        this.exceptions = Collections.unmodifiableList(localExceptions);
        this.message = this.exceptions.size() + " exceptions occurred. ";
    }

    @NonNull
    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    @NonNull
    public String getMessage() {
        return this.message;
    }

    @Override
    @NonNull
    public synchronized Throwable getCause() {
        if (this.cause == null) {
            CompositeExceptionCausalChain localCause = new CompositeExceptionCausalChain();
            HashSet<Throwable> seenCauses = new HashSet<Throwable>();
            Throwable chain = localCause;
            for (Throwable e : this.exceptions) {
                if (seenCauses.contains(e)) continue;
                seenCauses.add(e);
                List<Throwable> listOfCauses = this.getListOfCauses(e);
                for (Throwable child : listOfCauses) {
                    if (seenCauses.contains(child)) {
                        e = new RuntimeException("Duplicate found in causal chain so cropping to prevent loop ...");
                        continue;
                    }
                    seenCauses.add(child);
                }
                try {
                    chain.initCause(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                chain = this.getRootCause(chain);
            }
            this.cause = localCause;
        }
        return this.cause;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new WrappedPrintStream(s));
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(new WrappedPrintWriter(s));
    }

    private void printStackTrace(PrintStreamOrWriter s) {
        StringBuilder b = new StringBuilder(128);
        b.append(this).append('\n');
        for (StackTraceElement myStackElement : this.getStackTrace()) {
            b.append("\tat ").append(myStackElement).append('\n');
        }
        int i = 1;
        for (Throwable ex : this.exceptions) {
            b.append("  ComposedException ").append(i).append(" :\n");
            this.appendStackTrace(b, ex, "\t");
            ++i;
        }
        s.println(b.toString());
    }

    private void appendStackTrace(StringBuilder b, Throwable ex, String prefix) {
        b.append(prefix).append(ex).append('\n');
        for (StackTraceElement stackElement : ex.getStackTrace()) {
            b.append("\t\tat ").append(stackElement).append('\n');
        }
        if (ex.getCause() != null) {
            b.append("\tCaused by: ");
            this.appendStackTrace(b, ex.getCause(), "");
        }
    }

    private List<Throwable> getListOfCauses(Throwable ex) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        Throwable root = ex.getCause();
        if (root == null || root == ex) {
            return list;
        }
        while (true) {
            list.add(root);
            Throwable cause = root.getCause();
            if (cause == null || cause == root) {
                return list;
            }
            root = cause;
        }
    }

    public int size() {
        return this.exceptions.size();
    }

    Throwable getRootCause(Throwable e) {
        Throwable root = e.getCause();
        if (root == null || e == root) {
            return e;
        }
        Throwable cause;
        while ((cause = root.getCause()) != null && cause != root) {
            root = cause;
        }
        return root;
    }

    static final class CompositeExceptionCausalChain
    extends RuntimeException {
        private static final long serialVersionUID = 3875212506787802066L;
        static final String MESSAGE = "Chain of Causes for CompositeException In Order Received =>";

        CompositeExceptionCausalChain() {
        }

        @Override
        public String getMessage() {
            return MESSAGE;
        }
    }

    static final class WrappedPrintWriter
    extends PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        void println(Object o) {
            this.printWriter.println(o);
        }
    }

    static final class WrappedPrintStream
    extends PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        void println(Object o) {
            this.printStream.println(o);
        }
    }

    static abstract class PrintStreamOrWriter {
        PrintStreamOrWriter() {
        }

        abstract void println(Object var1);
    }
}

