/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResourceReader {
    private BeanFactory<MessageBodyReader<?>> factory;
    private List<String> mediaTypeStrings = new ArrayList<String>();
    private RuntimeType constraint;
    private boolean builtin = true;
    private Integer priority = 5000;
    private volatile List<MediaType> mediaTypes;
    private volatile MessageBodyReader<?> instance;

    public ResourceReader setFactory(BeanFactory<MessageBodyReader<?>> factory) {
        this.factory = factory;
        return this;
    }

    public BeanFactory<MessageBodyReader<?>> getFactory() {
        return this.factory;
    }

    public List<String> getMediaTypeStrings() {
        return this.mediaTypeStrings;
    }

    public ResourceReader setMediaTypeStrings(List<String> mediaTypeStrings) {
        this.mediaTypeStrings = mediaTypeStrings;
        return this;
    }

    public RuntimeType getConstraint() {
        return this.constraint;
    }

    public ResourceReader setConstraint(RuntimeType constraint) {
        this.constraint = constraint;
        return this;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public ResourceReader setBuiltin(boolean builtin) {
        this.builtin = builtin;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public ResourceReader setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBodyReader<?> instance() {
        if (this.instance == null) {
            ResourceReader resourceReader = this;
            synchronized (resourceReader) {
                if (this.instance == null) {
                    this.instance = this.factory.createInstance().getInstance();
                }
            }
        }
        return this.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaType> mediaTypes() {
        if (this.mediaTypes == null) {
            ResourceReader resourceReader = this;
            synchronized (resourceReader) {
                ArrayList<MediaType> mts = new ArrayList<MediaType>(this.mediaTypeStrings.size());
                for (int i = 0; i < this.mediaTypeStrings.size(); ++i) {
                    mts.add(MediaType.valueOf((String)this.mediaTypeStrings.get(i)));
                }
                this.mediaTypes = Collections.unmodifiableList(mts);
            }
        }
        return this.mediaTypes;
    }

    public boolean matchesRuntimeType(RuntimeType runtimeType) {
        if (runtimeType == null) {
            return true;
        }
        if (this.constraint == null) {
            return true;
        }
        return runtimeType == this.constraint;
    }

    public static class ResourceReaderComparator
    implements Comparator<ResourceReader> {
        private final List<MediaType> produces;

        public ResourceReaderComparator(List<MediaType> produces) {
            this.produces = produces;
        }

        @Override
        public int compare(ResourceReader o1, ResourceReader o2) {
            int builtInCompare = Boolean.compare(o1.isBuiltin(), o2.isBuiltin());
            if (builtInCompare != 0) {
                return builtInCompare;
            }
            int priorityCompare = Integer.compare(o1.getPriority(), o2.getPriority());
            if (priorityCompare != 0) {
                return priorityCompare;
            }
            List<MediaType> mediaTypes1 = o1.mediaTypes();
            List<MediaType> mediaTypes2 = o2.mediaTypes();
            if (mediaTypes1.isEmpty() && mediaTypes2.isEmpty()) {
                return 0;
            }
            if (mediaTypes1.isEmpty()) {
                return 1;
            }
            if (mediaTypes2.isEmpty()) {
                return -1;
            }
            int mediaTypeCompare = MediaTypeHelper.compareWeight(mediaTypes1.get(0), mediaTypes2.get(0));
            if (mediaTypeCompare != 0) {
                return mediaTypeCompare;
            }
            if (!this.produces.isEmpty() && (mediaTypeCompare = MediaTypeHelper.compareMatchingMediaTypes(this.produces, mediaTypes1, mediaTypes2)) != 0) {
                return mediaTypeCompare;
            }
            return Integer.compare(mediaTypes1.size(), mediaTypes2.size());
        }
    }
}

