/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.handlers;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import java.util.concurrent.Callable;
import org.jboss.resteasy.reactive.client.impl.ClientRequestContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.core.BlockingOperationSupport;

public class ClientResponseFilterRestHandler
implements ClientRestHandler {
    private final ClientResponseFilter filter;
    private final boolean preserveThread;

    public ClientResponseFilterRestHandler(ClientResponseFilter filter, boolean preserveThread) {
        this.filter = filter;
        this.preserveThread = preserveThread;
    }

    public void handle(final RestClientRequestContext requestContext) throws Exception {
        if (this.preserveThread) {
            this.doHandle(requestContext);
            return;
        }
        if (BlockingOperationSupport.isBlockingAllowed()) {
            this.doHandle(requestContext);
        } else {
            ClientRequestContextImpl clientRequestContext = requestContext.getClientRequestContext();
            final Context vertxContext = clientRequestContext.getContext();
            if (vertxContext != null) {
                requestContext.suspend();
                vertxContext.executeBlocking((Callable)new Callable<Object>(){

                    @Override
                    public Void call() {
                        ClientResponseFilterRestHandler.this.doHandle(requestContext);
                        return null;
                    }
                }, false).onComplete((Handler)new Handler<AsyncResult<Object>>(){

                    public void handle(final AsyncResult<Object> event) {
                        if (event.failed()) {
                            vertxContext.runOnContext((Handler)new Handler<Void>(){

                                public void handle(Void event2) {
                                    requestContext.resume(event.cause());
                                }
                            });
                        } else {
                            vertxContext.runOnContext((Handler)new Handler<Void>(){

                                public void handle(Void event2) {
                                    requestContext.resume();
                                }
                            });
                        }
                    }
                });
            } else {
                this.doHandle(requestContext);
            }
        }
    }

    private void doHandle(RestClientRequestContext requestContext) {
        try {
            this.filter.filter((ClientRequestContext)requestContext.getOrCreateClientRequestContext(), (ClientResponseContext)requestContext.getOrCreateClientResponseContext());
        }
        catch (ProcessingException | WebApplicationException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ProcessingException((Throwable)x);
        }
    }
}

