/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.CompletionStageRxInvoker;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.ClientRequestHeaders;
import org.jboss.resteasy.reactive.client.impl.HandlerChain;
import org.jboss.resteasy.reactive.client.impl.RequestSpec;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.util.types.Types;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class AsyncInvokerImpl
implements AsyncInvoker,
CompletionStageRxInvoker {
    public static final Buffer EMPTY_BUFFER = Buffer.buffer((byte[])new byte[0]);
    final HttpClient httpClient;
    final URI uri;
    final RequestSpec requestSpec;
    final ConfigurationImpl configuration;
    final Map<String, Object> properties;
    final ClientImpl restClient;
    final HandlerChain handlerChain;
    final ThreadSetupAction requestContext;

    public AsyncInvokerImpl(ClientImpl restClient, HttpClient httpClient, URI uri, RequestSpec requestSpec, ConfigurationImpl configuration, Map<String, Object> properties, HandlerChain handlerChain, ThreadSetupAction requestContext) {
        this.restClient = restClient;
        this.httpClient = httpClient;
        this.uri = uri;
        this.requestSpec = new RequestSpec(requestSpec);
        this.addUserInfoIfNecessary(this.uri, this.requestSpec);
        this.configuration = configuration;
        this.properties = new HashMap<String, Object>(properties);
        this.handlerChain = handlerChain;
        this.requestContext = requestContext;
    }

    private void addUserInfoIfNecessary(URI uri, RequestSpec requestSpec) {
        String userInfo = uri.getUserInfo();
        if (userInfo == null) {
            return;
        }
        String[] parts = userInfo.split(":");
        if (parts.length != 2) {
            return;
        }
        ClientRequestHeaders specHeaders = requestSpec.headers;
        String authorizationHeader = specHeaders.getHeader("Authorization");
        if (authorizationHeader == null) {
            specHeaders.header("Authorization", "Basic " + Base64.getEncoder().encodeToString((parts[0] + ":" + parts[1]).getBytes()));
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public CompletableFuture<Response> get() {
        return this.method("GET");
    }

    public <T> CompletableFuture<T> get(Class<T> responseType) {
        return this.method("GET", (Class)responseType);
    }

    public <T> CompletableFuture<T> get(GenericType<T> responseType) {
        return this.method("GET", (GenericType)responseType);
    }

    public <T> CompletableFuture<T> get(InvocationCallback<T> callback) {
        return this.method("GET", (InvocationCallback)callback);
    }

    public CompletableFuture<Response> put(Entity<?> entity) {
        return this.method("PUT", (Entity)entity);
    }

    public <T> CompletableFuture<T> put(Entity<?> entity, Class<T> responseType) {
        return this.method("PUT", (Entity)entity, (Class)responseType);
    }

    public <T> CompletableFuture<T> put(Entity<?> entity, GenericType<T> responseType) {
        return this.method("PUT", (Entity)entity, (GenericType)responseType);
    }

    public <T> CompletableFuture<T> put(Entity<?> entity, InvocationCallback<T> callback) {
        return this.method("PUT", (Entity)entity, (InvocationCallback)callback);
    }

    public CompletableFuture<Response> post(Entity<?> entity) {
        return this.method("POST", (Entity)entity);
    }

    public <T> CompletableFuture<T> post(Entity<?> entity, Class<T> responseType) {
        return this.method("POST", (Entity)entity, (Class)responseType);
    }

    public <T> CompletableFuture<T> post(Entity<?> entity, GenericType<T> responseType) {
        return this.method("POST", (Entity)entity, (GenericType)responseType);
    }

    public <T> CompletableFuture<T> post(Entity<?> entity, InvocationCallback<T> callback) {
        return this.method("POST", (Entity)entity, (InvocationCallback)callback);
    }

    public CompletableFuture<Response> delete() {
        return this.method("DELETE");
    }

    public <T> CompletableFuture<T> delete(Class<T> responseType) {
        return this.method("DELETE", (Class)responseType);
    }

    public <T> CompletableFuture<T> delete(GenericType<T> responseType) {
        return this.method("DELETE", (GenericType)responseType);
    }

    public <T> CompletableFuture<T> delete(InvocationCallback<T> callback) {
        return this.method("DELETE", (InvocationCallback)callback);
    }

    public CompletableFuture<Response> head() {
        return this.method("HEAD");
    }

    public Future<Response> head(InvocationCallback<Response> callback) {
        return this.method("HEAD", (InvocationCallback)callback);
    }

    public CompletableFuture<Response> options() {
        return this.method("OPTIONS");
    }

    public <T> CompletableFuture<T> options(Class<T> responseType) {
        return this.method("OPTIONS", (Class)responseType);
    }

    public <T> CompletableFuture<T> options(GenericType<T> responseType) {
        return this.method("OPTIONS", (GenericType)responseType);
    }

    public <T> CompletableFuture<T> options(InvocationCallback<T> callback) {
        return this.method("OPTIONS", (InvocationCallback)callback);
    }

    public CompletableFuture<Response> trace() {
        return this.method("TRACE");
    }

    public <T> CompletableFuture<T> trace(Class<T> responseType) {
        return this.method("TRACE", (Class)responseType);
    }

    public <T> CompletableFuture<T> trace(GenericType<T> responseType) {
        return this.method("TRACE", (GenericType)responseType);
    }

    public <T> CompletableFuture<T> trace(InvocationCallback<T> callback) {
        return this.method("TRACE", (InvocationCallback)callback);
    }

    public CompletableFuture<Response> method(String name) {
        return this.performRequestInternal(name, null, null);
    }

    public <T> CompletableFuture<T> method(String name, Class<T> responseType) {
        return this.mapResponse(this.performRequestInternal(name, null, new GenericType(responseType)), responseType);
    }

    public <T> CompletableFuture<T> method(String name, GenericType<T> responseType) {
        return this.mapResponse(this.performRequestInternal(name, null, responseType), responseType.getRawType());
    }

    public <T> CompletableFuture<T> method(String name, InvocationCallback<T> callback) {
        return this.method(name, (Entity)null, (InvocationCallback)callback);
    }

    public CompletableFuture<Response> method(String name, Entity<?> entity) {
        return this.performRequestInternal(name, entity, null);
    }

    public <T> CompletableFuture<T> method(String name, Entity<?> entity, Class<T> responseType) {
        CompletableFuture<Response> response = this.performRequestInternal(name, entity, new GenericType(responseType));
        return this.mapResponse(response, responseType);
    }

    public <T> CompletableFuture<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        CompletableFuture<Response> response = this.performRequestInternal(name, entity, responseType == null ? new GenericType(String.class) : responseType);
        return this.mapResponse(response, responseType == null ? String.class : responseType.getRawType());
    }

    public <T> CompletableFuture<T> method(String name, Entity<?> entity, final InvocationCallback<T> callback) {
        GenericType genericType = new GenericType(this.getInvocationCallbackType(callback));
        CompletableFuture<Object> cf = genericType.getRawType().equals(Response.class) ? this.performRequestInternal(name, entity, null) : this.mapResponse(this.performRequestInternal(name, entity, genericType), genericType.getRawType());
        cf.whenComplete(new BiConsumer<T, Throwable>(){

            @Override
            public void accept(T t, Throwable throwable) {
                if (throwable != null) {
                    callback.failed(throwable);
                } else {
                    callback.completed(t);
                }
            }
        });
        return cf;
    }

    private <T> CompletableFuture<Response> performRequestInternal(String httpMethodName, Entity<?> entity, GenericType<?> responseType) {
        return this.performRequestInternal(httpMethodName, entity, responseType, true).getResult();
    }

    RestClientRequestContext performRequestInternal(String httpMethodName, Entity<?> entity, GenericType<?> responseType, boolean registerBodyHandler) {
        RestClientRequestContext restClientRequestContext = new RestClientRequestContext(this.restClient, this.httpClient, httpMethodName, this.uri, this.requestSpec.configuration, this.requestSpec.headers, entity, responseType, registerBodyHandler, this.properties, this.handlerChain.createHandlerChain(this.configuration), this.handlerChain.createAbortHandlerChain(this.configuration), this.handlerChain.createAbortHandlerChainWithoutResponseFilters(), this.requestContext);
        restClientRequestContext.run();
        return restClientRequestContext;
    }

    private <T> Type getInvocationCallbackType(InvocationCallback<T> callback) {
        Class knownFromBuildTime = this.restClient.getClientContext().getGenericTypeMapping().forInvocationCallback(callback.getClass());
        if (knownFromBuildTime != null) {
            return knownFromBuildTime;
        }
        Type[] typeInfo = Types.getActualTypeArgumentsOfAnInterface((Class)callback.getClass(), InvocationCallback.class);
        if (typeInfo.length == 1) {
            return typeInfo[0];
        }
        return null;
    }

    public <T> CompletableFuture<T> mapResponse(CompletableFuture<Response> res, Class<?> responseType) {
        if (responseType.equals(Response.class)) {
            return res;
        }
        if (responseType.equals(RestResponse.class)) {
            return res.thenApply(new Function<Response, T>(){

                @Override
                public T apply(Response response) {
                    return RestResponse.ResponseBuilder.create((Response.StatusType)response.getStatusInfo(), (Object)response.getEntity()).replaceAll(response.getHeaders()).build();
                }
            });
        }
        return res.thenApply(new Function<Response, T>(){

            @Override
            public T apply(Response response) {
                return response.getEntity();
            }
        });
    }
}

