/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.WebSocketClientException;
import io.quarkus.websockets.next.WebSocketConnector;
import io.quarkus.websockets.next.runtime.ClientConnectionManager;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.Endpoints;
import io.quarkus.websockets.next.runtime.SecuritySupport;
import io.quarkus.websockets.next.runtime.TrafficLogger;
import io.quarkus.websockets.next.runtime.WebSocketClientConnectionImpl;
import io.quarkus.websockets.next.runtime.WebSocketClientRecorder;
import io.quarkus.websockets.next.runtime.WebSocketConnectorBase;
import io.quarkus.websockets.next.runtime.config.WebSocketsClientRuntimeConfig;
import io.quarkus.websockets.next.runtime.telemetry.SendingInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TelemetrySupport;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProvider;
import io.smallrye.mutiny.Uni;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxImpl;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.config.ConfigProvider;

@Typed(value={WebSocketConnector.class})
@Dependent
public class WebSocketConnectorImpl<CLIENT>
extends WebSocketConnectorBase<WebSocketConnectorImpl<CLIENT>>
implements WebSocketConnector<CLIENT> {
    private final WebSocketClientRecorder.ClientEndpoint clientEndpoint;
    private final WebSocketTelemetryProvider telemetryProvider;

    WebSocketConnectorImpl(InjectionPoint injectionPoint, Codecs codecs, Vertx vertx, ClientConnectionManager connectionManager, WebSocketClientRecorder.ClientEndpointsContext endpointsContext, WebSocketsClientRuntimeConfig config, TlsConfigurationRegistry tlsConfigurationRegistry, Instance<WebSocketTelemetryProvider> telemetryProvider) {
        super(vertx, codecs, connectionManager, config, tlsConfigurationRegistry);
        this.clientEndpoint = Objects.requireNonNull(endpointsContext.endpoint(this.getEndpointClass(injectionPoint)));
        this.telemetryProvider = telemetryProvider.isResolvable() ? (WebSocketTelemetryProvider)telemetryProvider.get() : null;
        this.setPath(this.clientEndpoint.path);
    }

    @Override
    public Uni<WebSocketClientConnection> connect() {
        URI serverEndpointUri;
        final AtomicReference client = new AtomicReference();
        StringBuilder serverEndpoint = new StringBuilder();
        if (this.baseUri != null) {
            serverEndpoint.append(this.baseUri.toString());
        } else {
            String key = this.clientEndpoint.clientId + ".base-uri";
            Optional maybeBaseUri = ConfigProvider.getConfig().getOptionalValue(key, String.class);
            if (maybeBaseUri.isEmpty()) {
                throw new WebSocketClientException("Unable to obtain the config value for: " + key);
            }
            serverEndpoint.append((String)maybeBaseUri.get());
        }
        serverEndpoint.append(this.replacePathParameters(this.clientEndpoint.path));
        try {
            serverEndpointUri = new URI(serverEndpoint.toString());
        }
        catch (URISyntaxException e2) {
            throw new WebSocketClientException(e2);
        }
        final WebSocketConnectOptions connectOptions = this.newConnectOptions(serverEndpointUri);
        StringBuilder uri = new StringBuilder();
        if (serverEndpointUri.getPath() != null) {
            uri.append(serverEndpointUri.getRawPath());
        }
        if (serverEndpointUri.getQuery() != null) {
            uri.append("?").append(serverEndpointUri.getQuery());
        }
        connectOptions.setURI(uri.toString());
        for (Map.Entry e3 : this.headers.entrySet()) {
            for (String val : (List)e3.getValue()) {
                connectOptions.addHeader((String)e3.getKey(), val);
            }
        }
        this.subprotocols.forEach(arg_0 -> ((WebSocketConnectOptions)connectOptions).addSubProtocol(arg_0));
        final TelemetrySupport telemetrySupport = this.telemetryProvider == null ? null : this.telemetryProvider.createClientTelemetrySupport(this.clientEndpoint.path);
        Uni websocket = Uni.createFrom().emitter(e -> {
            ContextImpl context = ((VertxImpl)this.vertx).createEventLoopContext();
            context.dispatch((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    WebSocketClient c = WebSocketConnectorImpl.this.vertx.createWebSocketClient(WebSocketConnectorImpl.this.populateClientOptions());
                    client.setPlain(c);
                    if (telemetrySupport != null && telemetrySupport.interceptConnection()) {
                        telemetrySupport.connectionOpened();
                    }
                    c.connect(connectOptions, (Handler)new Handler<AsyncResult<WebSocket>>(){

                        public void handle(AsyncResult<WebSocket> r) {
                            if (r.succeeded()) {
                                e.complete(r.result());
                            } else {
                                if (telemetrySupport != null && telemetrySupport.interceptConnection()) {
                                    telemetrySupport.connectionOpeningFailed(r.cause());
                                }
                                e.fail(r.cause());
                            }
                        }
                    });
                }
            });
        });
        return websocket.map(ws -> {
            TrafficLogger trafficLogger = TrafficLogger.forClient(this.config);
            SendingInterceptor sendingInterceptor = telemetrySupport == null ? null : telemetrySupport.getSendingInterceptor();
            WebSocketClientConnectionImpl connection = new WebSocketClientConnectionImpl(this.clientEndpoint.clientId, (WebSocket)ws, this.codecs, this.pathParams, serverEndpointUri, this.headers, trafficLogger, sendingInterceptor);
            if (trafficLogger != null) {
                trafficLogger.connectionOpened(connection);
            }
            this.connectionManager.add(this.clientEndpoint.generatedEndpointClass, connection);
            Endpoints.initialize(this.vertx, Arc.container(), this.codecs, connection, (WebSocketBase)ws, this.clientEndpoint.generatedEndpointClass, this.config.autoPingInterval(), SecuritySupport.NOOP, this.config.unhandledFailureStrategy(), trafficLogger, () -> {
                this.connectionManager.remove(this.clientEndpoint.generatedEndpointClass, connection);
                ((WebSocketClient)client.get()).close();
            }, true, true, telemetrySupport);
            return connection;
        });
    }

    String getEndpointClass(InjectionPoint injectionPoint) {
        ParameterizedType parameterizedType = (ParameterizedType)injectionPoint.getType();
        return parameterizedType.getActualTypeArguments()[0].getTypeName();
    }
}

