/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.deployment;

import io.quarkus.gizmo2.Expr;
import io.quarkus.websockets.next.WebSocketException;
import io.quarkus.websockets.next.deployment.Callback;
import io.quarkus.websockets.next.deployment.CallbackArgument;
import io.quarkus.websockets.next.deployment.WebSocketDotNames;
import org.jboss.jandex.DotName;

class ConnectionCallbackArgument
implements CallbackArgument {
    ConnectionCallbackArgument() {
    }

    @Override
    public boolean matches(CallbackArgument.ParameterContext context) {
        DotName paramTypeName = context.parameter().type().name();
        if (context.callbackTarget() == Callback.Target.SERVER) {
            if (WebSocketDotNames.WEB_SOCKET_CONNECTION.equals((Object)paramTypeName) || WebSocketDotNames.CONNECTION.equals((Object)paramTypeName)) {
                return true;
            }
            if (WebSocketDotNames.WEB_SOCKET_CLIENT_CONNECTION.equals((Object)paramTypeName)) {
                throw new WebSocketException("@WebSocket callback method may not accept WebSocketClientConnection");
            }
        } else if (context.callbackTarget() == Callback.Target.CLIENT) {
            if (WebSocketDotNames.WEB_SOCKET_CLIENT_CONNECTION.equals((Object)paramTypeName) || WebSocketDotNames.CONNECTION.equals((Object)paramTypeName)) {
                return true;
            }
            if (WebSocketDotNames.WEB_SOCKET_CONNECTION.equals((Object)paramTypeName)) {
                throw new WebSocketException("@WebSocketClient callback method may not accept WebSocketConnection");
            }
        }
        return false;
    }

    @Override
    public Expr get(CallbackArgument.InvocationBytecodeContext context) {
        return context.getConnection();
    }
}

