/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.console.DevConsoleRequest;
import io.quarkus.dev.console.DevConsoleResponse;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;

public class DevConsoleFilter
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger(DevConsoleFilter.class);

    public void handle(final RoutingContext event) {
        DevConsoleRequest request;
        final TreeMap<String, List> headers = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry entry : event.request().headers()) {
            headers.put((String)entry.getKey(), event.request().headers().getAll((String)entry.getKey()));
        }
        if (event.getBody() != null) {
            event.request().resume();
            request = new DevConsoleRequest(event.request().method().name(), event.request().uri(), headers, event.getBody().getBytes());
            this.setupFuture(event, request.getResponse());
            DevConsoleManager.sentRequest((DevConsoleRequest)request);
        } else if (event.request().isEnded()) {
            event.request().resume();
            request = new DevConsoleRequest(event.request().method().name(), event.request().uri(), headers, new byte[0]);
            this.setupFuture(event, request.getResponse());
            DevConsoleManager.sentRequest((DevConsoleRequest)request);
        } else {
            event.request().bodyHandler((Handler)new Handler<Buffer>(){

                public void handle(Buffer body) {
                    DevConsoleRequest request = new DevConsoleRequest(event.request().method().name(), event.request().uri(), headers, body.getBytes());
                    DevConsoleFilter.this.setupFuture(event, request.getResponse());
                    DevConsoleManager.sentRequest((DevConsoleRequest)request);
                }
            });
            event.request().resume();
        }
    }

    private void setupFuture(final RoutingContext event, CompletableFuture<DevConsoleResponse> response) {
        response.handle(new BiFunction<DevConsoleResponse, Throwable, Object>(){

            @Override
            public Object apply(DevConsoleResponse devConsoleResponse, Throwable throwable) {
                if (throwable != null) {
                    log.error((Object)"Failed to handle dev console request", throwable);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    throwable.printStackTrace(new PrintWriter(baos));
                    event.response().setStatusCode(500).end(Buffer.buffer((byte[])baos.toByteArray()));
                } else {
                    for (Map.Entry entry : devConsoleResponse.getHeaders().entrySet()) {
                        event.response().headers().add((String)entry.getKey(), (Iterable)entry.getValue());
                    }
                    event.response().setStatusCode(devConsoleResponse.getStatus()).end(Buffer.buffer((ByteBuf)Unpooled.copiedBuffer((byte[])devConsoleResponse.getBody())));
                }
                return null;
            }
        });
    }
}

