/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.jsonrpc;

import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.vertx.core.json.JsonObject;
import java.util.Map;

public class JsonRpcRequest {
    private final JsonMapper jsonMapper;
    private final JsonObject jsonObject;

    JsonRpcRequest(JsonMapper jsonMapper, JsonObject jsonObject) {
        this.jsonMapper = jsonMapper;
        this.jsonObject = jsonObject;
    }

    public int getId() {
        return this.jsonObject.getInteger("id");
    }

    public String getJsonrpc() {
        String value = this.jsonObject.getString("jsonrpc");
        if (value != null) {
            return value;
        }
        return "2.0";
    }

    public String getMethod() {
        return this.jsonObject.getString("method");
    }

    public boolean hasParams() {
        return this.getParams() != null;
    }

    public Map<?, ?> getParams() {
        JsonObject paramsObject = this.jsonObject.getJsonObject("params");
        if (paramsObject != null && paramsObject.getMap() != null && !paramsObject.getMap().isEmpty()) {
            return paramsObject.getMap();
        }
        return null;
    }

    public <T> T getParam(String key, Class<T> paramType) {
        Map<?, ?> params = this.getParams();
        if (params == null || !params.containsKey(key)) {
            return null;
        }
        return this.jsonMapper.fromValue(params.get(key), paramType);
    }

    public String toString() {
        return this.jsonMapper.toString(this.jsonObject, true);
    }
}

