/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.deployment;

import io.quarkus.spring.security.deployment.DotNames;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class StringPropertyAccessorData {
    private final ClassInfo matchingParameterClassInfo;
    private final FieldInfo matchingParameterFieldInfo;

    private StringPropertyAccessorData(ClassInfo matchingParameterClassInfo, FieldInfo matchingParameterFieldInfo) {
        this.matchingParameterClassInfo = matchingParameterClassInfo;
        this.matchingParameterFieldInfo = matchingParameterFieldInfo;
    }

    static StringPropertyAccessorData from(MethodInfo methodInfo, int matchingParameterIndex, String propertyName, IndexView index, String expression) {
        Type matchingParameterType = methodInfo.parameterType(matchingParameterIndex);
        ClassInfo matchingParameterClassInfo = index.getClassByName(matchingParameterType.name());
        if (matchingParameterClassInfo == null) {
            throw new IllegalArgumentException("Expression: '" + expression + "' in the @PreAuthorize annotation on method '" + methodInfo.name() + "' of class '" + methodInfo.declaringClass() + "' references class " + matchingParameterType.name() + " which could not be in Jandex");
        }
        FieldInfo matchingParameterFieldInfo = matchingParameterClassInfo.field(propertyName);
        if (matchingParameterFieldInfo == null) {
            throw new IllegalArgumentException("Expression: '" + expression + "' in the @PreAuthorize annotation on method '" + methodInfo.name() + "' of class '" + methodInfo.declaringClass() + "' references unknown property '" + propertyName + "' of class " + matchingParameterClassInfo);
        }
        if (!DotNames.STRING.equals((Object)matchingParameterFieldInfo.type().name())) {
            throw new IllegalArgumentException("Expression: '" + expression + "' in the @PreAuthorize annotation on method '" + methodInfo.name() + "' of class '" + methodInfo.declaringClass() + "' references property '" + propertyName + "' which is not a string");
        }
        return new StringPropertyAccessorData(matchingParameterClassInfo, matchingParameterFieldInfo);
    }

    public ClassInfo getMatchingParameterClassInfo() {
        return this.matchingParameterClassInfo;
    }

    public FieldInfo getMatchingParameterFieldInfo() {
        return this.matchingParameterFieldInfo;
    }
}

