/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.common.deployment;

import io.quarkus.arc.processor.DotNames;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.security.jpa.common.deployment.QuarkusSecurityJpaCommonProcessor;
import java.lang.reflect.Modifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class JpaSecurityDefinition {
    public final FieldOrMethod username;
    public final FieldOrMethod password;
    public final FieldOrMethod roles;
    public final ClassInfo annotatedClass;

    public boolean haveRolesAnnotation(DotName ... annotations) {
        for (DotName annotation : annotations) {
            if (this.roles.annotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    public JpaSecurityDefinition(Index index, ClassInfo annotatedClass, boolean isPanache, AnnotationTarget usernameFieldOrMethod, AnnotationTarget passwordFieldOrMethod, AnnotationTarget rolesFieldOrMethod) {
        this.annotatedClass = annotatedClass;
        this.username = JpaSecurityDefinition.getFieldOrMethod(index, annotatedClass, usernameFieldOrMethod, isPanache);
        this.password = JpaSecurityDefinition.getFieldOrMethod(index, annotatedClass, passwordFieldOrMethod, isPanache);
        this.roles = JpaSecurityDefinition.getFieldOrMethod(index, annotatedClass, rolesFieldOrMethod, isPanache);
    }

    public static FieldOrMethod getFieldOrMethod(Index index, ClassInfo annotatedClass, AnnotationTarget annotatedFieldOrMethod, boolean isPanache) {
        if (annotatedFieldOrMethod == null) {
            return null;
        }
        switch (annotatedFieldOrMethod.kind()) {
            case FIELD: {
                FieldInfo field = annotatedFieldOrMethod.asField();
                return new FieldOrMethod(field, JpaSecurityDefinition.findGetter(index, annotatedClass, field, Modifier.isPublic(field.flags()) && isPanache));
            }
            case METHOD: {
                return new FieldOrMethod(null, annotatedFieldOrMethod.asMethod());
            }
        }
        throw new IllegalArgumentException("annotatedFieldOrMethod must be a field or method: " + annotatedFieldOrMethod);
    }

    public AnnotationValue passwordType() {
        return this.password.annotation(QuarkusSecurityJpaCommonProcessor.DOTNAME_PASSWORD).value();
    }

    public AnnotationValue customPasswordProvider() {
        return this.password.annotation(QuarkusSecurityJpaCommonProcessor.DOTNAME_PASSWORD).value("provider");
    }

    private static MethodInfo findGetter(Index index, ClassInfo annotatedClass, FieldInfo field, boolean isPanache) {
        String methodName = "get" + JavaBeanUtil.capitalize((String)field.name());
        if (isPanache) {
            return MethodInfo.create((ClassInfo)field.declaringClass(), (String)methodName, (Type[])new Type[0], (Type)field.type(), (short)1);
        }
        return JpaSecurityDefinition.findGetter(index, annotatedClass, methodName);
    }

    private static MethodInfo findGetter(Index index, ClassInfo annotatedClass, String methodName) {
        ClassInfo superClass;
        MethodInfo method = annotatedClass.method(methodName, new Type[0]);
        if (method != null) {
            return method;
        }
        DotName superName = annotatedClass.superName();
        if (superName != null && !superName.equals((Object)DotNames.OBJECT) && (superClass = index.getClassByName(superName)) != null && (method = JpaSecurityDefinition.findGetter(index, superClass, methodName)) != null) {
            return method;
        }
        for (DotName interfaceName : annotatedClass.interfaceNames()) {
            ClassInfo interf = index.getClassByName(interfaceName);
            if (interf == null || (method = JpaSecurityDefinition.findGetter(index, interf, methodName)) == null) continue;
            return method;
        }
        return null;
    }

    public static class FieldOrMethod {
        public final FieldInfo field;
        public final MethodInfo getter;

        public FieldOrMethod(FieldInfo field, MethodInfo getter) {
            this.field = field;
            this.getter = getter;
        }

        public AnnotationInstance annotation(DotName annotationName) {
            if (this.field != null) {
                return this.field.annotation(annotationName);
            }
            return this.getter.annotation(annotationName);
        }

        public String name() {
            if (this.field != null) {
                return this.field.name();
            }
            return JavaBeanUtil.getPropertyNameFromGetter((String)this.getter.name());
        }

        public ResultHandle readValue(BytecodeCreator bytecodeCreator, ResultHandle userVar) {
            if (this.getter != null) {
                return bytecodeCreator.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)this.getter), userVar, new ResultHandle[0]);
            }
            return bytecodeCreator.readInstanceField(FieldDescriptor.of((FieldInfo)this.field), userVar);
        }

        public Type type() {
            if (this.field != null) {
                return this.field.type();
            }
            return this.getter.returnType();
        }
    }
}

