/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@Priority(value=1000)
@Provider
public class EagerSecurityFilter
implements ContainerRequestFilter {
    private static final Consumer<RoutingContext> NULL_SENTINEL = new Consumer<RoutingContext>(){

        @Override
        public void accept(RoutingContext routingContext) {
        }
    };
    private final Map<MethodDescription, Consumer<RoutingContext>> cache = new HashMap<MethodDescription, Consumer<RoutingContext>>();
    @Context
    ResourceInfo resourceInfo;
    @Inject
    EagerSecurityInterceptorStorage interceptorStorage;
    @Inject
    RoutingContext routingContext;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        MethodDescription description = MethodDescription.ofMethod((Method)this.resourceInfo.getResourceMethod());
        Consumer interceptor = this.cache.get(description);
        if (interceptor == NULL_SENTINEL) {
            return;
        }
        if (interceptor != null) {
            interceptor.accept((RoutingContext)this.routingContext);
        }
        if ((interceptor = this.interceptorStorage.getInterceptor(description)) == null) {
            this.cache.put(description, NULL_SENTINEL);
        } else {
            this.cache.put(description, interceptor);
            interceptor.accept(this.routingContext);
        }
    }
}

