/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links;

import io.quarkus.arc.Arc;
import io.quarkus.resteasy.reactive.links.RestLinkType;
import io.quarkus.resteasy.reactive.links.RestLinksProvider;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.util.Collection;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class RestLinksHandler
implements ServerRestHandler {
    private RestLinkData restLinkData;

    public RestLinkData getRestLinkData() {
        return this.restLinkData;
    }

    public void setRestLinkData(RestLinkData restLinkData) {
        this.restLinkData = restLinkData;
    }

    public void handle(ResteasyReactiveRequestContext context) {
        context.requireCDIRequestScope();
        Response response = context.getResponse().get();
        for (Link link : this.getLinks(response)) {
            response.getHeaders().add((Object)"Link", (Object)link);
        }
    }

    private Collection<Link> getLinks(Response response) {
        RestLinksProvider provider = this.getRestLinksProvider();
        if (this.restLinkData.getRestLinkType() == RestLinkType.INSTANCE && response.hasEntity()) {
            return provider.getInstanceLinks(response.getEntity());
        }
        return provider.getTypeLinks(this.restLinkData.getEntityType() != null ? this.entityTypeClass() : response.getEntity().getClass());
    }

    private Class<?> entityTypeClass() {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(this.restLinkData.getEntityType());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable load class '" + this.restLinkData.getEntityType() + "'", e);
        }
    }

    private RestLinksProvider getRestLinksProvider() {
        return (RestLinksProvider)Arc.container().instance(RestLinksProvider.class, new Annotation[0]).get();
    }

    public static class RestLinkData {
        private RestLinkType restLinkType;
        private String entityType;

        public RestLinkData(RestLinkType restLinkType, String entityType) {
            this.restLinkType = restLinkType;
            this.entityType = entityType;
        }

        public RestLinkData() {
        }

        public RestLinkType getRestLinkType() {
            return this.restLinkType;
        }

        public void setRestLinkType(RestLinkType restLinkType) {
            this.restLinkType = restLinkType;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public void setEntityType(String entityType) {
            this.entityType = entityType;
        }
    }
}

