/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.ClientWebApplicationException;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.server.jackson.JacksonBasicMessageBodyReader;

public class ClientJacksonMessageBodyReader
extends JacksonBasicMessageBodyReader
implements ClientRestHandler {
    private final ConcurrentMap<ObjectMapper, ObjectReader> contextResolverMap = new ConcurrentHashMap<ObjectMapper, ObjectReader>();
    private RestClientRequestContext context;

    @Inject
    public ClientJacksonMessageBodyReader(ObjectMapper mapper) {
        super(mapper);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        catch (StreamReadException | DatabindException e) {
            throw new ClientWebApplicationException(e, Response.Status.BAD_REQUEST);
        }
    }

    public void handle(RestClientRequestContext requestContext) {
        this.context = requestContext;
    }

    protected ObjectReader getEffectiveReader() {
        if (this.context == null) {
            return super.getEffectiveReader();
        }
        ObjectMapper objectMapper = (ObjectMapper)this.context.getConfiguration().getFromContext(ObjectMapper.class);
        if (objectMapper == null) {
            return super.getEffectiveReader();
        }
        return this.contextResolverMap.computeIfAbsent(objectMapper, new Function<ObjectMapper, ObjectReader>(){

            @Override
            public ObjectReader apply(ObjectMapper objectMapper) {
                return objectMapper.reader();
            }
        });
    }
}

