/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.restclient.config.RegisteredRestClient;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;

public final class RegisteredRestClientBuildItem
extends MultiBuildItem {
    private final ClassInfo classInfo;
    private final Optional<String> configKey;
    private final Optional<String> defaultBaseUri;

    public RegisteredRestClientBuildItem(ClassInfo classInfo, Optional<String> configKey, Optional<String> defaultBaseUri) {
        this.classInfo = Objects.requireNonNull(classInfo);
        this.configKey = Objects.requireNonNull(configKey);
        this.defaultBaseUri = Objects.requireNonNull(defaultBaseUri);
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public Optional<String> getConfigKey() {
        return this.configKey;
    }

    public Optional<String> getDefaultBaseUri() {
        return this.defaultBaseUri;
    }

    public static List<RegisteredRestClient> toRegisteredRestClients(List<RegisteredRestClientBuildItem> restClients) {
        return restClients.stream().map(rc -> new RegisteredRestClient(rc.getClassInfo().name().toString(), rc.getClassInfo().simpleName(), (String)rc.getConfigKey().orElse(null))).toList();
    }
}

