/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.SignatureBuilder;
import io.quarkus.gizmo.Type;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.rest.client.reactive.deployment.GeneratedClassResult;
import io.quarkus.rest.client.reactive.runtime.ResteasyReactiveContextResolver;
import io.quarkus.runtime.util.HashUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;

class ClientContextResolverHandler {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final ResultHandle[] EMPTY_RESULT_HANDLES_ARRAY = new ResultHandle[0];
    private static final MethodDescriptor GET_INVOKED_METHOD = MethodDescriptor.ofMethod(RestClientRequestContext.class, (String)"getInvokedMethod", Method.class, (Class[])new Class[0]);
    private final DotName annotation;
    private final Class<?> expectedReturnType;
    private final ClassOutput classOutput;

    ClientContextResolverHandler(DotName annotation, Class<?> expectedReturnType, ClassOutput classOutput) {
        this.annotation = annotation;
        this.expectedReturnType = expectedReturnType;
        this.classOutput = classOutput;
    }

    GeneratedClassResult generateContextResolver(AnnotationInstance instance) {
        Class<?> returnTypeClassName;
        if (!this.annotation.equals((Object)instance.name())) {
            throw new IllegalArgumentException("'clientContextResolverInstance' must be an instance of " + this.annotation);
        }
        MethodInfo targetMethod = this.findTargetMethod(instance);
        if (targetMethod == null) {
            return null;
        }
        int priority = 5000;
        AnnotationValue priorityAnnotationValue = instance.value("priority");
        if (priorityAnnotationValue != null) {
            priority = priorityAnnotationValue.asInt();
        }
        if (!this.expectedReturnType.isAssignableFrom(returnTypeClassName = ClientContextResolverHandler.lookupReturnClass(targetMethod))) {
            throw new IllegalStateException(this.annotation + " is only supported on static methods of REST Client interfaces that return '" + this.expectedReturnType + "'. Offending instance is '" + targetMethod.declaringClass().name().toString() + "#" + targetMethod.name() + "'");
        }
        ClassInfo restClientInterfaceClassInfo = targetMethod.declaringClass();
        String generatedClassName = ClientContextResolverHandler.getGeneratedClassName(targetMethod);
        try (ClassCreator cc = ClassCreator.builder().classOutput(this.classOutput).className(generatedClassName).signature(SignatureBuilder.forClass().addInterface(Type.parameterizedType((Type.ClassType)Type.classType(ResteasyReactiveContextResolver.class), (Type[])new Type[]{Type.classType(returnTypeClassName)}))).build();){
            MethodCreator getContext = cc.getMethodCreator("getContext", Object.class, new Class[]{Class.class});
            LinkedHashMap<String, ResultHandle> targetMethodParams = new LinkedHashMap<String, ResultHandle>();
            for (org.jboss.jandex.Type paramType : targetMethod.parameterTypes()) {
                ResultHandle targetMethodParamHandle = paramType.name().equals((Object)DotNames.METHOD) ? getContext.invokeVirtualMethod(GET_INVOKED_METHOD, getContext.getMethodParam(1), new ResultHandle[0]) : ClientContextResolverHandler.getFromCDI(getContext, targetMethod.returnType().name().toString());
                targetMethodParams.put(paramType.name().toString(), targetMethodParamHandle);
            }
            ResultHandle resultHandle = getContext.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod((String)restClientInterfaceClassInfo.name().toString(), (String)targetMethod.name(), (String)targetMethod.returnType().name().toString(), (String[])targetMethodParams.keySet().toArray(EMPTY_STRING_ARRAY)), targetMethodParams.values().toArray(EMPTY_RESULT_HANDLES_ARRAY));
            getContext.returnValue(resultHandle);
        }
        return new GeneratedClassResult(restClientInterfaceClassInfo.name().toString(), generatedClassName, priority);
    }

    private MethodInfo findTargetMethod(AnnotationInstance instance) {
        MethodInfo targetMethod = null;
        if (instance.target().kind() == AnnotationTarget.Kind.METHOD) {
            targetMethod = instance.target().asMethod();
            if (ClientContextResolverHandler.ignoreAnnotation(targetMethod)) {
                return null;
            }
            if ((targetMethod.flags() & 8) != 0 && targetMethod.returnType().kind() == Type.Kind.VOID) {
                throw new IllegalStateException(this.annotation + " is only supported on static methods of REST Client interfaces that return an object. Offending instance is '" + targetMethod.declaringClass().name().toString() + "#" + targetMethod.name() + "'");
            }
        }
        return targetMethod;
    }

    private static Class<?> lookupReturnClass(MethodInfo targetMethod) {
        Class<?> returnTypeClassName = null;
        try {
            returnTypeClassName = Class.forName(targetMethod.returnType().name().toString(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return returnTypeClassName;
    }

    private static ResultHandle getFromCDI(MethodCreator getContext, String className) {
        ResultHandle containerHandle = getContext.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instanceHandle = getContext.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), containerHandle, new ResultHandle[]{getContext.loadClassFromTCCL(className), getContext.newArray(Annotation.class, 0)});
        return getContext.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
    }

    public static String getGeneratedClassName(MethodInfo methodInfo) {
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(methodInfo.name()).append("_").append(methodInfo.returnType().name().toString());
        for (org.jboss.jandex.Type i : methodInfo.parameterTypes()) {
            sigBuilder.append(i.name().toString());
        }
        return methodInfo.declaringClass().name().toString() + "_" + methodInfo.name() + "_ContextResolver_" + HashUtil.sha1((String)sigBuilder.toString());
    }

    private static boolean ignoreAnnotation(MethodInfo methodInfo) {
        return methodInfo.declaringClass().name().toString().contains("$Companion");
    }
}

