/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.db2.client.runtime;

import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.runtime.ConnectOptionsSupplier;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveRuntimeConfig;
import io.quarkus.reactive.datasource.runtime.UnitisedTime;
import io.quarkus.reactive.db2.client.DB2PoolCreator;
import io.quarkus.reactive.db2.client.runtime.DataSourceReactiveDB2Config;
import io.quarkus.reactive.db2.client.runtime.DataSourcesReactiveDB2Config;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.mutiny.db2client.DB2Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.impl.Utils;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class DB2PoolRecorder {
    private static final Logger log = Logger.getLogger(DB2PoolRecorder.class);
    private static final TypeLiteral<Instance<DB2PoolCreator>> TYPE_LITERAL = new TypeLiteral<Instance<DB2PoolCreator>>(){};

    public Function<SyntheticCreationalContext<io.vertx.db2client.DB2Pool>, io.vertx.db2client.DB2Pool> configureDB2Pool(final RuntimeValue<Vertx> vertx, final Supplier<Integer> eventLoopCount, final String dataSourceName, final DataSourcesRuntimeConfig dataSourcesRuntimeConfig, final DataSourcesReactiveRuntimeConfig dataSourcesReactiveRuntimeConfig, final DataSourcesReactiveDB2Config dataSourcesReactiveDB2Config, final ShutdownContext shutdown) {
        return new Function<SyntheticCreationalContext<io.vertx.db2client.DB2Pool>, io.vertx.db2client.DB2Pool>(){

            @Override
            public io.vertx.db2client.DB2Pool apply(SyntheticCreationalContext<io.vertx.db2client.DB2Pool> context) {
                io.vertx.db2client.DB2Pool db2Pool = DB2PoolRecorder.this.initialize((VertxInternal)vertx.getValue(), (Integer)eventLoopCount.get(), dataSourceName, (DataSourceRuntimeConfig)dataSourcesRuntimeConfig.dataSources().get(dataSourceName), dataSourcesReactiveRuntimeConfig.getDataSourceReactiveRuntimeConfig(dataSourceName), dataSourcesReactiveDB2Config.dataSources().get(dataSourceName).reactive().db2(), context);
                shutdown.addShutdownTask(() -> ((io.vertx.db2client.DB2Pool)db2Pool).close());
                return db2Pool;
            }
        };
    }

    public Function<SyntheticCreationalContext<DB2Pool>, DB2Pool> mutinyDB2Pool(final Function<SyntheticCreationalContext<io.vertx.db2client.DB2Pool>, io.vertx.db2client.DB2Pool> function) {
        return new Function<SyntheticCreationalContext<DB2Pool>, DB2Pool>(){

            @Override
            public DB2Pool apply(SyntheticCreationalContext context) {
                return DB2Pool.newInstance((io.vertx.db2client.DB2Pool)((io.vertx.db2client.DB2Pool)function.apply(context)));
            }
        };
    }

    private io.vertx.db2client.DB2Pool initialize(VertxInternal vertx, Integer eventLoopCount, String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveDB2Config dataSourceReactiveDB2Config, SyntheticCreationalContext<io.vertx.db2client.DB2Pool> context) {
        PoolOptions poolOptions = this.toPoolOptions(eventLoopCount, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveDB2Config);
        DB2ConnectOptions db2ConnectOptions = this.toConnectOptions(dataSourceName, dataSourceRuntimeConfig, dataSourceReactiveRuntimeConfig, dataSourceReactiveDB2Config);
        Supplier<Future<DB2ConnectOptions>> databasesSupplier = this.toDatabasesSupplier((Vertx)vertx, List.of(db2ConnectOptions), dataSourceRuntimeConfig);
        return this.createPool((Vertx)vertx, poolOptions, db2ConnectOptions, dataSourceName, databasesSupplier, context);
    }

    private Supplier<Future<DB2ConnectOptions>> toDatabasesSupplier(Vertx vertx, List<DB2ConnectOptions> db2ConnectOptionsList, DataSourceRuntimeConfig dataSourceRuntimeConfig) {
        Supplier supplier;
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            supplier = new ConnectOptionsSupplier(vertx, credentialsProvider, name, db2ConnectOptionsList, DB2ConnectOptions::new);
        } else {
            supplier = Utils.roundRobinSupplier(db2ConnectOptionsList);
        }
        return supplier;
    }

    private PoolOptions toPoolOptions(Integer eventLoopCount, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveDB2Config dataSourceReactiveDB2Config) {
        PoolOptions poolOptions = new PoolOptions();
        poolOptions.setMaxSize(dataSourceReactiveRuntimeConfig.maxSize());
        if (dataSourceReactiveRuntimeConfig.idleTimeout().isPresent()) {
            UnitisedTime idleTimeout = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.idleTimeout().get()));
            poolOptions.setIdleTimeout(idleTimeout.value).setIdleTimeoutUnit(idleTimeout.unit);
        }
        if (dataSourceReactiveRuntimeConfig.maxLifetime().isPresent()) {
            UnitisedTime maxLifetime = UnitisedTime.unitised((Duration)((Duration)dataSourceReactiveRuntimeConfig.maxLifetime().get()));
            poolOptions.setMaxLifetime(maxLifetime.value).setMaxLifetimeUnit(maxLifetime.unit);
        }
        if (dataSourceReactiveRuntimeConfig.shared()) {
            poolOptions.setShared(true);
            if (dataSourceReactiveRuntimeConfig.name().isPresent()) {
                poolOptions.setName((String)dataSourceReactiveRuntimeConfig.name().get());
            }
        }
        if (dataSourceReactiveRuntimeConfig.eventLoopSize().isPresent()) {
            poolOptions.setEventLoopSize(Math.max(0, dataSourceReactiveRuntimeConfig.eventLoopSize().getAsInt()));
        } else if (eventLoopCount != null) {
            poolOptions.setEventLoopSize(Math.max(0, eventLoopCount));
        }
        return poolOptions;
    }

    private DB2ConnectOptions toConnectOptions(String dataSourceName, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceReactiveRuntimeConfig dataSourceReactiveRuntimeConfig, DataSourceReactiveDB2Config dataSourceReactiveDB2Config) {
        DB2ConnectOptions connectOptions;
        if (dataSourceReactiveRuntimeConfig.url().isPresent()) {
            String url;
            List urls = (List)dataSourceReactiveRuntimeConfig.url().get();
            if (urls.size() > 1) {
                log.warn((Object)"The Reactive DB2 client does not support multiple URLs. The first one will be used, and others will be ignored.");
            }
            if ((url = (String)urls.get(0)).matches("^vertx-reactive:db2://.*$")) {
                url = url.substring("vertx-reactive:".length());
            }
            connectOptions = DB2ConnectOptions.fromUri((String)url);
        } else {
            connectOptions = new DB2ConnectOptions();
        }
        if (dataSourceRuntimeConfig.username().isPresent()) {
            connectOptions.setUser((String)dataSourceRuntimeConfig.username().get());
        }
        if (dataSourceRuntimeConfig.password().isPresent()) {
            connectOptions.setPassword((String)dataSourceRuntimeConfig.password().get());
        }
        if (dataSourceRuntimeConfig.credentialsProvider().isPresent()) {
            String beanName = dataSourceRuntimeConfig.credentialsProviderName().orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = (String)dataSourceRuntimeConfig.credentialsProvider().get();
            Map credentials = credentialsProvider.getCredentials(name);
            String user = (String)credentials.get("user");
            String password = (String)credentials.get("password");
            if (user != null) {
                connectOptions.setUser(user);
            }
            if (password != null) {
                connectOptions.setPassword(password);
            }
        }
        connectOptions.setCachePreparedStatements(dataSourceReactiveRuntimeConfig.cachePreparedStatements());
        connectOptions.setSsl(dataSourceReactiveDB2Config.ssl());
        connectOptions.setTrustAll(dataSourceReactiveRuntimeConfig.trustAll());
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)connectOptions, (PemTrustCertConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePem());
        SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)connectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.trustCertificateJks());
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)connectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.trustCertificatePfx());
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)connectOptions, (PemKeyCertConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePem());
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)connectOptions, (JksConfiguration)dataSourceReactiveRuntimeConfig.keyCertificateJks());
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)connectOptions, (PfxConfiguration)dataSourceReactiveRuntimeConfig.keyCertificatePfx());
        connectOptions.setReconnectAttempts(dataSourceReactiveRuntimeConfig.reconnectAttempts());
        connectOptions.setReconnectInterval(dataSourceReactiveRuntimeConfig.reconnectInterval().toMillis());
        if (dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm().isPresent()) {
            connectOptions.setHostnameVerificationAlgorithm((String)dataSourceReactiveRuntimeConfig.hostnameVerificationAlgorithm().get());
        }
        dataSourceReactiveRuntimeConfig.additionalProperties().forEach((arg_0, arg_1) -> ((DB2ConnectOptions)connectOptions).addProperty(arg_0, arg_1));
        connectOptions.setMetricsName("db2|" + dataSourceName);
        return connectOptions;
    }

    private io.vertx.db2client.DB2Pool createPool(Vertx vertx, PoolOptions poolOptions, DB2ConnectOptions dB2ConnectOptions, String dataSourceName, Supplier<Future<DB2ConnectOptions>> databases, SyntheticCreationalContext<io.vertx.db2client.DB2Pool> context) {
        Instance instance = DataSourceUtil.isDefault((String)dataSourceName) ? (Instance)context.getInjectedReference(TYPE_LITERAL, new Annotation[0]) : (Instance)context.getInjectedReference(TYPE_LITERAL, new Annotation[]{new ReactiveDataSource.ReactiveDataSourceLiteral(dataSourceName)});
        if (instance.isResolvable()) {
            DefaultInput input = new DefaultInput(vertx, poolOptions, dB2ConnectOptions);
            return ((DB2PoolCreator)instance.get()).create(input);
        }
        return io.vertx.db2client.DB2Pool.pool((Vertx)vertx, databases, (PoolOptions)poolOptions);
    }

    private static class DefaultInput
    implements DB2PoolCreator.Input {
        private final Vertx vertx;
        private final PoolOptions poolOptions;
        private final DB2ConnectOptions dB2ConnectOptions;

        public DefaultInput(Vertx vertx, PoolOptions poolOptions, DB2ConnectOptions dB2ConnectOptions) {
            this.vertx = vertx;
            this.poolOptions = poolOptions;
            this.dB2ConnectOptions = dB2ConnectOptions;
        }

        @Override
        public Vertx vertx() {
            return this.vertx;
        }

        @Override
        public PoolOptions poolOptions() {
            return this.poolOptions;
        }

        @Override
        public DB2ConnectOptions db2ConnectOptions() {
            return this.dB2ConnectOptions;
        }
    }
}

