/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import java.nio.file.Path;
import java.util.Objects;

public final class TemplatePathBuildItem
extends MultiBuildItem {
    public static final int ROOT_ARCHIVE_PRIORITY = 30;
    public static final int BUILD_ITEM_PRIORITY = 20;
    public static final int APP_ARCHIVE_PRIORITY = 10;
    static final String TAGS = "tags/";
    private final String path;
    private final String content;
    private final Path fullPath;
    private final String extensionInfo;
    private final int priority;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated(forRemoval=true, since="3.13")
    public TemplatePathBuildItem(String path, Path fullPath, String content) {
        this(Objects.requireNonNull(path), Objects.requireNonNull(content), Objects.requireNonNull(fullPath), null, 20);
    }

    private TemplatePathBuildItem(String path, String content, Path fullPath, String extensionInfo, int priority) {
        this.path = path;
        this.content = content;
        this.fullPath = fullPath;
        this.extensionInfo = extensionInfo;
        this.priority = priority;
    }

    public String getPath() {
        return this.path;
    }

    public Path getFullPath() {
        return this.fullPath;
    }

    public String getContent() {
        return this.content;
    }

    public String getExtensionInfo() {
        return this.extensionInfo;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isTag() {
        return this.path.startsWith(TAGS);
    }

    public boolean isRegular() {
        return !this.isTag();
    }

    public boolean isFileBased() {
        return this.fullPath != null;
    }

    public String getSourceInfo() {
        return (this.isFileBased() ? this.getFullPath().toString() : this.extensionInfo) + " [" + this.getPriority() + "]";
    }

    public static class Builder {
        private String path;
        private String content;
        private Path fullPath;
        private String extensionInfo;
        private int priority = 20;

        public Builder path(String path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public Builder content(String content) {
            this.content = Objects.requireNonNull(content);
            return this;
        }

        public Builder fullPath(Path fullPath) {
            this.fullPath = Objects.requireNonNull(fullPath);
            return this;
        }

        public Builder extensionInfo(String info) {
            this.extensionInfo = info;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public TemplatePathBuildItem build() {
            if (this.fullPath == null && this.extensionInfo == null) {
                throw new IllegalStateException("Templates that are not backed by a file must provide extension info");
            }
            return new TemplatePathBuildItem(this.path, this.content, this.fullPath, this.extensionInfo, this.priority);
        }
    }
}

