/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.arc.processor.DotNames;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public final class Types {
    static final String JAVA_LANG_PREFIX = "java.lang.";

    static Set<Type> getTypeClosure(ClassInfo classInfo, Map<TypeVariable, Type> resolvedTypeParameters, IndexView index) {
        ClassInfo superClassInfo;
        HashSet<Type> types = new HashSet<Type>();
        List typeParameters = classInfo.typeParameters();
        if (typeParameters.isEmpty() || !resolvedTypeParameters.keySet().containsAll(typeParameters)) {
            types.add(Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS));
        } else {
            Type[] typeParams = new Type[typeParameters.size()];
            for (int i = 0; i < typeParameters.size(); ++i) {
                typeParams[i] = resolvedTypeParameters.get(typeParameters.get(i));
            }
            types.add((Type)ParameterizedType.create((DotName)classInfo.name(), (Type[])typeParams, null));
        }
        for (Type interfaceType : classInfo.interfaceTypes()) {
            ClassInfo interfaceClassInfo = index.getClassByName(interfaceType.name());
            if (interfaceClassInfo == null) continue;
            Map<TypeVariable, Type> resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)interfaceType.kind())) {
                resolved = Types.buildResolvedMap(interfaceType.asParameterizedType().arguments(), interfaceClassInfo.typeParameters(), resolvedTypeParameters, index);
            }
            types.addAll(Types.getTypeClosure(interfaceClassInfo, resolved, index));
        }
        if (classInfo.superClassType() != null && (superClassInfo = index.getClassByName(classInfo.superName())) != null) {
            Map<TypeVariable, Type> resolved = Collections.emptyMap();
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)classInfo.superClassType().kind())) {
                resolved = Types.buildResolvedMap(classInfo.superClassType().asParameterizedType().arguments(), superClassInfo.typeParameters(), resolvedTypeParameters, index);
            }
            types.addAll(Types.getTypeClosure(superClassInfo, resolved, index));
        }
        return types;
    }

    static <T extends Type> Map<TypeVariable, Type> buildResolvedMap(List<T> resolvedArguments, List<TypeVariable> typeVariables, Map<TypeVariable, Type> resolvedTypeParameters, IndexView index) {
        HashMap<TypeVariable, Type> resolvedMap = new HashMap<TypeVariable, Type>();
        for (int i = 0; i < resolvedArguments.size(); ++i) {
            resolvedMap.put(typeVariables.get(i), Types.resolveTypeParam((Type)resolvedArguments.get(i), resolvedTypeParameters, index));
        }
        return resolvedMap;
    }

    static Type resolveTypeParam(Type typeParam, Map<TypeVariable, Type> resolvedTypeParameters, IndexView index) {
        if (typeParam.kind() == Type.Kind.CLASS) {
            ClassInfo classInfo = index.getClassByName(typeParam.name());
            if (classInfo == null && !typeParam.name().toString().contains(".") && (classInfo = index.getClassByName(DotName.createSimple((String)(JAVA_LANG_PREFIX + typeParam.name().toString())))) != null) {
                return Type.create((DotName)classInfo.name(), (Type.Kind)Type.Kind.CLASS);
            }
            return typeParam;
        }
        if (typeParam.kind() == Type.Kind.TYPE_VARIABLE) {
            return resolvedTypeParameters.getOrDefault(typeParam, typeParam);
        }
        if (typeParam.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType parameterizedType = typeParam.asParameterizedType();
            ClassInfo classInfo = index.getClassByName(parameterizedType.name());
            if (classInfo == null && !parameterizedType.name().toString().contains(".")) {
                classInfo = index.getClassByName(DotName.createSimple((String)(JAVA_LANG_PREFIX + parameterizedType.name().toString())));
            }
            if (classInfo != null) {
                List typeParameters = classInfo.typeParameters();
                List arguments = parameterizedType.arguments();
                Type[] typeParams = new Type[typeParameters.size()];
                for (int i = 0; i < typeParameters.size(); ++i) {
                    typeParams[i] = Types.resolveTypeParam((Type)arguments.get(i), resolvedTypeParameters, index);
                }
                return ParameterizedType.create((DotName)parameterizedType.name(), (Type[])typeParams, null);
            }
        }
        return typeParam;
    }

    static boolean containsTypeVariable(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            for (Type t : type.asParameterizedType().arguments()) {
                if (!Types.containsTypeVariable(t)) continue;
                return true;
            }
        }
        if (type.kind() == Type.Kind.ARRAY) {
            return Types.containsTypeVariable(type.asArrayType().component());
        }
        return false;
    }

    static boolean isAssignableFrom(Type type1, Type type2, IndexView index, Map<DotName, AssignableInfo> assignableCache) {
        if (type1.kind() == Type.Kind.ARRAY && type2.kind() == Type.Kind.ARRAY) {
            return Types.isAssignableFrom(type1.asArrayType().component(), type2.asArrayType().component(), index, assignableCache);
        }
        return Types.isAssignableFrom(Types.box(type1).name(), Types.box(type2).name(), index, assignableCache);
    }

    static boolean isAssignableFrom(DotName class1, DotName class2, IndexView index, Map<DotName, AssignableInfo> assignableCache) {
        if (class1.equals((Object)DotNames.OBJECT)) {
            return true;
        }
        if (class1.equals((Object)class2)) {
            return true;
        }
        AssignableInfo assignableInfo = assignableCache.get(class1);
        if (assignableInfo == null) {
            assignableInfo = new AssignableInfo(index.getAllKnownSubclasses(class1), index.getAllKnownImplementors(class1), Types.getAllInterfacesExtending(class1, index));
            assignableCache.put(class1, assignableInfo);
        }
        return assignableInfo.isAssignableFrom(class2);
    }

    static void indexHierarchy(ClassInfo classInfo, IndexView index) {
        for (DotName interfaceName : classInfo.interfaceNames()) {
            index.getClassByName(interfaceName);
        }
        DotName superName = classInfo.superName();
        if (superName != null && !superName.equals((Object)DotNames.OBJECT)) {
            Types.indexHierarchy(index.getClassByName(superName), index);
        }
    }

    static Type box(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return Types.box(type.asPrimitiveType().primitive());
        }
        return type;
    }

    static Type box(PrimitiveType.Primitive primitive) {
        switch (primitive) {
            case BOOLEAN: {
                return Type.create((DotName)DotNames.BOOLEAN, (Type.Kind)Type.Kind.CLASS);
            }
            case DOUBLE: {
                return Type.create((DotName)DotNames.DOUBLE, (Type.Kind)Type.Kind.CLASS);
            }
            case FLOAT: {
                return Type.create((DotName)DotNames.FLOAT, (Type.Kind)Type.Kind.CLASS);
            }
            case LONG: {
                return Type.create((DotName)DotNames.LONG, (Type.Kind)Type.Kind.CLASS);
            }
            case INT: {
                return Type.create((DotName)DotNames.INTEGER, (Type.Kind)Type.Kind.CLASS);
            }
            case BYTE: {
                return Type.create((DotName)DotNames.BYTE, (Type.Kind)Type.Kind.CLASS);
            }
            case CHAR: {
                return Type.create((DotName)DotNames.CHARACTER, (Type.Kind)Type.Kind.CLASS);
            }
            case SHORT: {
                return Type.create((DotName)DotNames.SHORT, (Type.Kind)Type.Kind.CLASS);
            }
        }
        throw new IllegalArgumentException("Unsupported primitive: " + primitive);
    }

    private static Set<DotName> getAllInterfacesExtending(DotName target, IndexView index) {
        HashSet<DotName> ret = new HashSet<DotName>();
        for (ClassInfo clazz : index.getKnownClasses()) {
            if (!Modifier.isInterface(clazz.flags()) || clazz.isAnnotation() || clazz.isEnum() || !clazz.interfaceNames().contains(target)) continue;
            ret.add(clazz.name());
        }
        return ret;
    }

    static class AssignableInfo {
        final Set<DotName> subclasses = new HashSet<DotName>();
        final Set<DotName> implementors;
        final Set<DotName> extendingInterfaces;

        public AssignableInfo(Collection<ClassInfo> subclasses, Collection<ClassInfo> implementors, Set<DotName> extendingInterfaces) {
            for (ClassInfo subclass : subclasses) {
                this.subclasses.add(subclass.name());
            }
            this.implementors = new HashSet<DotName>();
            for (ClassInfo implementor : implementors) {
                this.implementors.add(implementor.name());
            }
            this.extendingInterfaces = extendingInterfaces;
        }

        boolean isAssignableFrom(DotName clazz) {
            return this.subclasses.contains(clazz) || this.implementors.contains(clazz) || this.extendingInterfaces.contains(clazz);
        }
    }
}

