/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.exporter.otlp.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.opentelemetry.exporter.internal.TlsUtil;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

@TargetClass(className="io.opentelemetry.exporter.internal.grpc.ManagedChannelUtil")
final class Target_io_opentelemetry_exporter_otlp_internal_grpc_ManagedChannelUtil {
    Target_io_opentelemetry_exporter_otlp_internal_grpc_ManagedChannelUtil() {
    }

    @Substitute
    public static void setClientKeysAndTrustedCertificatesPem(ManagedChannelBuilder<?> managedChannelBuilder, byte[] privateKeyPem, byte[] certificatePem, byte[] trustedCertificatesPem) throws SSLException {
        Objects.requireNonNull(managedChannelBuilder, "managedChannelBuilder");
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        X509TrustManager tmf = TlsUtil.trustManager((byte[])trustedCertificatesPem);
        X509KeyManager kmf = null;
        if (privateKeyPem != null && certificatePem != null) {
            kmf = TlsUtil.keyManager((byte[])privateKeyPem, (byte[])certificatePem);
        }
        if (!managedChannelBuilder.getClass().getName().equals("io.grpc.netty.NettyChannelBuilder")) {
            throw new SSLException("TLS certificate configuration not supported for unrecognized ManagedChannelBuilder " + managedChannelBuilder.getClass().getName());
        }
        NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)managedChannelBuilder;
        nettyBuilder.sslContext(GrpcSslContexts.forClient().keyManager((KeyManager)kmf).trustManager((TrustManager)tmf).build());
    }
}

