/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.websockets;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.quarkus.micrometer.runtime.binder.websockets.WebSocketMetricConstants;
import io.quarkus.websockets.next.runtime.spi.telemetry.WebSocketMetricsInterceptorProducer;
import jakarta.enterprise.context.Dependent;

@Dependent
public final class WebSocketMetricsInterceptorProducerImpl
implements WebSocketMetricsInterceptorProducer {
    private static final String URI_TAG_KEY = "uri";
    private final MeterRegistry meterRegistry;

    WebSocketMetricsInterceptorProducerImpl(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public WebSocketMetricsInterceptorProducer.WebSocketMetricsInterceptor createServerMetricsInterceptor() {
        Meter.MeterProvider messagesCounter = Counter.builder((String)"quarkus.websockets.server.count").description("Number of messages sent and received by server endpoints.").withRegistry(this.meterRegistry);
        Meter.MeterProvider bytesCounter = Counter.builder((String)"quarkus.websockets.server.bytes").description("Number of bytes sent and received by server endpoints.").withRegistry(this.meterRegistry);
        Meter.MeterProvider closedConnectionCounter = Counter.builder((String)"quarkus.websockets.server.connections.closed").description("Number of closed server WebSocket connections.").withRegistry(this.meterRegistry);
        Meter.MeterProvider serverErrorsCounter = Counter.builder((String)"quarkus.websockets.server.endpoint.count.errors").description("Counts all the WebSockets server endpoint errors.").withRegistry(this.meterRegistry);
        Meter.MeterProvider connectionOpenCounter = Counter.builder((String)"quarkus.websockets.server.connections.opened").description("Number of opened server connections.").withRegistry(this.meterRegistry);
        Meter.MeterProvider connectionOnOpenErrorsCounter = Counter.builder((String)"quarkus.websockets.server.connections.onopen.errors").description("Number of failures occurred when opening server connection failed.").withRegistry(this.meterRegistry);
        return new WebSocketMetricsInterceptorImpl((Meter.MeterProvider<Counter>)messagesCounter, (Meter.MeterProvider<Counter>)bytesCounter, (Meter.MeterProvider<Counter>)closedConnectionCounter, (Meter.MeterProvider<Counter>)serverErrorsCounter, (Meter.MeterProvider<Counter>)connectionOpenCounter, (Meter.MeterProvider<Counter>)connectionOnOpenErrorsCounter);
    }

    public WebSocketMetricsInterceptorProducer.WebSocketMetricsInterceptor createClientMetricsInterceptor() {
        Meter.MeterProvider messagesCounter = Counter.builder((String)"quarkus.websockets.client.count").description("Number of messages sent and received by client endpoints.").withRegistry(this.meterRegistry);
        Meter.MeterProvider bytesCounter = Counter.builder((String)"quarkus.websockets.client.bytes").description("Number of bytes sent and received by client endpoints.").withRegistry(this.meterRegistry);
        Meter.MeterProvider closedConnectionCounter = Counter.builder((String)"quarkus.websockets.client.connections.closed").description("Number of closed client WebSocket connections.").withRegistry(this.meterRegistry);
        Meter.MeterProvider clientErrorsCounter = Counter.builder((String)"quarkus.websockets.client.endpoint.count.errors").description("Counts all the WebSockets client endpoint errors.").withRegistry(this.meterRegistry);
        Meter.MeterProvider connectionOpenCounter = Counter.builder((String)"quarkus.websockets.client.connections.opened").description("Number of opened client connections.").withRegistry(this.meterRegistry);
        Meter.MeterProvider connectionOnOpenErrorsCounter = Counter.builder((String)"quarkus.websockets.client.connections.onopen.errors").description("Number of failures occurred when opening client connection failed.").withRegistry(this.meterRegistry);
        return new WebSocketMetricsInterceptorImpl((Meter.MeterProvider<Counter>)messagesCounter, (Meter.MeterProvider<Counter>)bytesCounter, (Meter.MeterProvider<Counter>)closedConnectionCounter, (Meter.MeterProvider<Counter>)clientErrorsCounter, (Meter.MeterProvider<Counter>)connectionOpenCounter, (Meter.MeterProvider<Counter>)connectionOnOpenErrorsCounter);
    }

    private static final class WebSocketMetricsInterceptorImpl
    implements WebSocketMetricsInterceptorProducer.WebSocketMetricsInterceptor {
        private final Meter.MeterProvider<Counter> messagesCounter;
        private final Meter.MeterProvider<Counter> bytesCounter;
        private final Meter.MeterProvider<Counter> closedConnectionCounter;
        private final Meter.MeterProvider<Counter> errorsCounter;
        private final Meter.MeterProvider<Counter> connectionOpenCounter;
        private final Meter.MeterProvider<Counter> connectionOnOpenErrorsCounter;

        private WebSocketMetricsInterceptorImpl(Meter.MeterProvider<Counter> messagesCounter, Meter.MeterProvider<Counter> bytesCounter, Meter.MeterProvider<Counter> closedConnectionCounter, Meter.MeterProvider<Counter> errorsCounter, Meter.MeterProvider<Counter> connectionOpenCounter, Meter.MeterProvider<Counter> connectionOnOpenErrorsCounter) {
            this.messagesCounter = messagesCounter;
            this.bytesCounter = bytesCounter;
            this.closedConnectionCounter = closedConnectionCounter;
            this.errorsCounter = errorsCounter;
            this.connectionOpenCounter = connectionOpenCounter;
            this.connectionOnOpenErrorsCounter = connectionOnOpenErrorsCounter;
        }

        public void onError(String route) {
            ((Counter)this.errorsCounter.withTag(WebSocketMetricsInterceptorProducerImpl.URI_TAG_KEY, route)).increment();
        }

        public void onMessageSent(byte[] data, String route) {
            ((Counter)this.messagesCounter.withTags(new String[]{WebSocketMetricsInterceptorProducerImpl.URI_TAG_KEY, route, "direction", WebSocketMetricConstants.Direction.OUTBOUND.toString()})).increment();
            ((Counter)this.bytesCounter.withTags(new String[]{WebSocketMetricsInterceptorProducerImpl.URI_TAG_KEY, route, "direction", WebSocketMetricConstants.Direction.OUTBOUND.toString()})).increment((double)data.length);
        }

        public void onMessageReceived(byte[] data, String route) {
            ((Counter)this.messagesCounter.withTags(new String[]{WebSocketMetricsInterceptorProducerImpl.URI_TAG_KEY, route, "direction", WebSocketMetricConstants.Direction.INBOUND.toString()})).increment();
            ((Counter)this.bytesCounter.withTags(new String[]{WebSocketMetricsInterceptorProducerImpl.URI_TAG_KEY, route, "direction", WebSocketMetricConstants.Direction.INBOUND.toString()})).increment((double)data.length);
        }

        public void onConnectionOpened(String route) {
            ((Counter)this.connectionOpenCounter.withTag(WebSocketMetricsInterceptorProducerImpl.URI_TAG_KEY, route)).increment();
        }

        public void onConnectionOpeningFailed(String route) {
            ((Counter)this.connectionOnOpenErrorsCounter.withTag(WebSocketMetricsInterceptorProducerImpl.URI_TAG_KEY, route)).increment();
        }

        public void onConnectionClosed(String route) {
            ((Counter)this.closedConnectionCounter.withTag(WebSocketMetricsInterceptorProducerImpl.URI_TAG_KEY, route)).increment();
        }
    }
}

