package io.quarkus.kubernetes.spi;

import java.util.Collections;
import java.util.Map;

/**
 * Produce this build item to request the Kubernetes extension to generate
 * a Kubernetes {@code RoleBinding} resource.
 * <p>
 * Use {@link KubernetesClusterRoleBindingBuildItem} to generate a {@code ClusterRoleBinding}.
 */
public final class KubernetesRoleBindingBuildItem extends BaseTargetable {
    /**
     * Name of the generated {@code RoleBinding} resource.
     * Can be {@code null}, in which case the resource name is autogenerated.
     */
    private final String name;
    private final String namespace;
    /**
     * RoleRef configuration.
     */
    private final RoleRef roleRef;
    /**
     * The target subjects.
     */
    private final Subject[] subjects;

    /**
     * The labels of the cluster role resource.
     */
    private final Map<String, String> labels;

    public KubernetesRoleBindingBuildItem(String role, boolean clusterWide) {
        this(null, role, clusterWide, null);
    }

    public KubernetesRoleBindingBuildItem(String name, String role, boolean clusterWide) {
        this(name, role, clusterWide, null);
    }

    public KubernetesRoleBindingBuildItem(String name, String role, boolean clusterWide, String target) {
        this(name, target, Collections.emptyMap(),
                new RoleRef(role, clusterWide),
                new Subject("", "ServiceAccount", name, null));
    }

    public KubernetesRoleBindingBuildItem(String name, String target, Map<String, String> labels, RoleRef roleRef,
            Subject... subjects) {
        this(name, null, target, labels, roleRef, subjects);
    }

    public KubernetesRoleBindingBuildItem(String name, String namespace, String target, Map<String, String> labels,
            RoleRef roleRef,
            Subject... subjects) {
        super(target);
        this.name = name;
        this.namespace = namespace;
        this.labels = labels;
        this.roleRef = roleRef;
        this.subjects = subjects;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return namespace;
    }

    public Map<String, String> getLabels() {
        return labels;
    }

    public RoleRef getRoleRef() {
        return roleRef;
    }

    public Subject[] getSubjects() {
        return subjects;
    }
}
