/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.admin.client.common;

import io.quarkus.keycloak.admin.client.common.KeycloakAdminClientConfig;
import org.jboss.logging.Logger;

public class KeycloakAdminClientConfigUtil {
    private static final Logger LOG = Logger.getLogger(KeycloakAdminClientConfigUtil.class);

    public static void validate(KeycloakAdminClientConfig config) {
        if (config.serverUrl.isEmpty()) {
            LOG.debug((Object)"Configuration property 'server-url' is not set, 'Keycloak' admin client injection will fail, use org.keycloak.admin.client.KeycloakBuilder to create it instead");
            return;
        }
        if (config.grantType == KeycloakAdminClientConfig.GrantType.PASSWORD) {
            if (config.password.isEmpty() || config.username.isEmpty()) {
                throw new KeycloakAdminClientException("grant type 'password' requires username and password");
            }
        } else if (config.clientSecret.isEmpty()) {
            throw new KeycloakAdminClientException("grant type 'client_credentials' requires client secret");
        }
    }

    static final class KeycloakAdminClientException
    extends RuntimeException {
        private KeycloakAdminClientException(String message) {
            super(String.format("Failed to create Keycloak admin client: %s.", message));
        }
    }
}

