/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.serialization;

import io.quarkus.kafka.client.serialization.JsonbProducer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import javax.json.bind.Jsonb;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonbDeserializer<T>
implements Deserializer<T> {
    private final Jsonb jsonb;
    private final Type type;
    private final boolean jsonbNeedsClosing;

    public JsonbDeserializer(Class<T> clazz) {
        this(clazz, JsonbProducer.get(), true);
    }

    public JsonbDeserializer(Class<T> clazz, Jsonb jsonb) {
        this(clazz, jsonb, false);
    }

    private JsonbDeserializer(Class<T> clazz, Jsonb jsonb, boolean jsonbNeedsClosing) {
        this.type = clazz;
        this.jsonb = jsonb;
        this.jsonbNeedsClosing = jsonbNeedsClosing;
    }

    public JsonbDeserializer(Type type) {
        this(type, JsonbProducer.get(), true);
    }

    public JsonbDeserializer(Type type, Jsonb jsonb) {
        this(type, jsonb, false);
    }

    private JsonbDeserializer(Type type, Jsonb jsonb, boolean jsonbNeedsClosing) {
        this.type = type;
        this.jsonb = jsonb;
        this.jsonbNeedsClosing = jsonbNeedsClosing;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            Object object = this.jsonb.fromJson((InputStream)is, this.type);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (!this.jsonbNeedsClosing) {
            return;
        }
        try {
            this.jsonb.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

