/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.util;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.TestResourceScope;
import io.quarkus.test.common.WithTestResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.main.QuarkusMainTest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.ClassOrdererContext;
import org.junit.jupiter.api.Nested;

public class QuarkusTestProfileAwareClassOrderer
implements ClassOrderer {
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST = "20_";
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_MATCHING_RES = "30_";
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE = "40_";
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES = "45_";
    protected static final String DEFAULT_ORDER_PREFIX_NON_QUARKUS_TEST = "60_";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST = "junit.quarkus.orderer.prefix.quarkus-test";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_MATCHING_RES = "junit.quarkus.orderer.prefix.quarkus-test-with-matching-resource";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE = "junit.quarkus.orderer.prefix.quarkus-test-with-profile";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES = "junit.quarkus.orderer.prefix.quarkus-test-with-restricted-resource";
    static final String CFGKEY_ORDER_PREFIX_NON_QUARKUS_TEST = "junit.quarkus.orderer.prefix.non-quarkus-test";
    static final String CFGKEY_SECONDARY_ORDERER = "junit.quarkus.orderer.secondary-orderer";
    private final String prefixQuarkusTest;
    private final String prefixQuarkusTestWithProfile;
    private final String prefixQuarkusTestWithRestrictedResource;
    private final String prefixQuarkusTestWithMatchingResource;
    private final String prefixNonQuarkusTest;
    private final Optional<String> secondaryOrderer;

    public QuarkusTestProfileAwareClassOrderer() {
        Config config = ConfigProvider.getConfig();
        this.prefixQuarkusTest = config.getOptionalValue(CFGKEY_ORDER_PREFIX_QUARKUS_TEST, String.class).orElse(DEFAULT_ORDER_PREFIX_QUARKUS_TEST);
        this.prefixQuarkusTestWithMatchingResource = config.getOptionalValue(CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_MATCHING_RES, String.class).orElse(DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_MATCHING_RES);
        this.prefixQuarkusTestWithProfile = config.getOptionalValue(CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE, String.class).orElse(DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE);
        this.prefixQuarkusTestWithRestrictedResource = config.getOptionalValue(CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES, String.class).orElse(DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_RESTRICTED_RES);
        this.prefixNonQuarkusTest = config.getOptionalValue(CFGKEY_ORDER_PREFIX_NON_QUARKUS_TEST, String.class).orElse(DEFAULT_ORDER_PREFIX_NON_QUARKUS_TEST);
        this.secondaryOrderer = config.getOptionalValue(CFGKEY_SECONDARY_ORDERER, String.class);
    }

    QuarkusTestProfileAwareClassOrderer(String prefixQuarkusTest, String prefixQuarkusTestWithMatchingResource, String prefixQuarkusTestWithProfile, String prefixQuarkusTestWithRestrictedResource, String prefixNonQuarkusTest, Optional<String> secondaryOrderer) {
        this.prefixQuarkusTest = prefixQuarkusTest;
        this.prefixQuarkusTestWithMatchingResource = prefixQuarkusTestWithMatchingResource;
        this.prefixQuarkusTestWithProfile = prefixQuarkusTestWithProfile;
        this.prefixQuarkusTestWithRestrictedResource = prefixQuarkusTestWithRestrictedResource;
        this.prefixNonQuarkusTest = prefixNonQuarkusTest;
        this.secondaryOrderer = secondaryOrderer;
    }

    public void orderClasses(ClassOrdererContext context) {
        if (context.getClassDescriptors().size() <= 1 || ((ClassDescriptor)context.getClassDescriptors().get(0)).isAnnotated(Nested.class)) {
            return;
        }
        this.secondaryOrderer.map(fqcn -> {
            try {
                return (ClassOrderer)Class.forName(fqcn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Failed to instantiate " + fqcn, e);
            }
        }).orElseGet(ClassOrderer.ClassName::new).orderClasses(context);
        List classDescriptors = context.getClassDescriptors();
        Map<ClassDescriptor, String> firstPassIndexMap = IntStream.range(0, classDescriptors.size()).boxed().collect(Collectors.toMap(classDescriptors::get, i -> String.format("%06d", i)));
        classDescriptors.sort(Comparator.comparing(classDescriptor -> {
            String secondaryOrderSuffix = (String)firstPassIndexMap.get(classDescriptor);
            Optional<String> customOrderKey = this.getCustomOrderKey((ClassDescriptor)classDescriptor, context, secondaryOrderSuffix).or(() -> this.getCustomOrderKey((ClassDescriptor)classDescriptor, context));
            if (customOrderKey.isPresent()) {
                return customOrderKey.get();
            }
            if (classDescriptor.isAnnotated(QuarkusTest.class) || classDescriptor.isAnnotated(QuarkusIntegrationTest.class) || classDescriptor.isAnnotated(QuarkusMainTest.class)) {
                return classDescriptor.findAnnotation(TestProfile.class).map(TestProfile::value).map(profileClass -> this.prefixQuarkusTestWithProfile + profileClass.getName() + "@" + secondaryOrderSuffix).orElseGet(() -> {
                    String prefix = this.prefixQuarkusTest;
                    String suffix = "";
                    TestResourceScope mostLimitedScope = this.mostLimitedScope((ClassDescriptor)classDescriptor);
                    if (mostLimitedScope != null) {
                        if (mostLimitedScope == TestResourceScope.RESTRICTED_TO_CLASS) {
                            prefix = this.prefixQuarkusTestWithRestrictedResource;
                        } else {
                            prefix = this.prefixQuarkusTestWithMatchingResource;
                            suffix = String.join((CharSequence)",", this.lifecycleManagerClassNamesForNonRestricted((ClassDescriptor)classDescriptor));
                        }
                    }
                    return prefix + suffix + secondaryOrderSuffix;
                });
            }
            return this.prefixNonQuarkusTest + secondaryOrderSuffix;
        }));
    }

    private TestResourceScope mostLimitedScope(ClassDescriptor classDescriptor) {
        TestResourceScope result = null;
        for (WithTestResource annotation : classDescriptor.findRepeatableAnnotations(WithTestResource.class)) {
            if (this.isMetaTestResource(annotation, classDescriptor)) {
                result = TestResourceScope.RESTRICTED_TO_CLASS;
                continue;
            }
            TestResourceScope scope = annotation.scope();
            if (result != null && scope.compareTo((Enum)result) >= 0) continue;
            result = scope;
        }
        for (WithTestResource annotation : classDescriptor.findRepeatableAnnotations(QuarkusTestResource.class)) {
            if (this.isMetaTestResource((QuarkusTestResource)annotation, classDescriptor) || annotation.restrictToAnnotatedClass()) {
                result = TestResourceScope.RESTRICTED_TO_CLASS;
                continue;
            }
            result = TestResourceScope.GLOBAL;
        }
        return result;
    }

    private Set<String> lifecycleManagerClassNamesForNonRestricted(ClassDescriptor classDescriptor) {
        HashSet<String> result = new HashSet<String>();
        for (WithTestResource annotation : classDescriptor.findRepeatableAnnotations(WithTestResource.class)) {
            TestResourceScope scope = annotation.scope();
            if (scope == TestResourceScope.RESTRICTED_TO_CLASS || this.isMetaTestResource(annotation, classDescriptor)) continue;
            result.add(annotation.value().getSimpleName());
        }
        for (WithTestResource annotation : classDescriptor.findRepeatableAnnotations(QuarkusTestResource.class)) {
            if (annotation.restrictToAnnotatedClass() || this.isMetaTestResource((QuarkusTestResource)annotation, classDescriptor)) continue;
            result.add(annotation.value().getSimpleName());
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    private boolean isMetaTestResource(QuarkusTestResource resource, ClassDescriptor classDescriptor) {
        return Arrays.stream((QuarkusTestResource[])classDescriptor.getTestClass().getAnnotationsByType(QuarkusTestResource.class)).map(QuarkusTestResource::value).noneMatch(resource.value()::equals);
    }

    private boolean isMetaTestResource(WithTestResource resource, ClassDescriptor classDescriptor) {
        return Arrays.stream((WithTestResource[])classDescriptor.getTestClass().getAnnotationsByType(WithTestResource.class)).map(WithTestResource::value).noneMatch(resource.value()::equals);
    }

    @Deprecated(forRemoval=true, since="2.7.0.CR1")
    protected Optional<String> getCustomOrderKey(ClassDescriptor classDescriptor, ClassOrdererContext context) {
        return Optional.empty();
    }

    protected Optional<String> getCustomOrderKey(ClassDescriptor classDescriptor, ClassOrdererContext context, String secondaryOrderSuffix) {
        return Optional.empty();
    }
}

