/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.infinispan.client.runtime.InfinispanClientRuntimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanClientUtil;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithParentName;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
@ConfigMapping(prefix="quarkus.infinispan-client")
public interface InfinispanClientsRuntimeConfig {
    @WithParentName
    public InfinispanClientRuntimeConfig defaultInfinispanClient();

    @WithParentName
    @ConfigDocMapKey(value="client-name")
    @ConfigDocSection
    public Map<String, InfinispanClientRuntimeConfig> namedInfinispanClients();

    @WithDefault(value="true")
    public Optional<Boolean> useSchemaRegistration();

    @WithDefault(value="true")
    public Optional<Boolean> startClient();

    default public InfinispanClientRuntimeConfig getInfinispanClientRuntimeConfig(String infinispanClientName) {
        if (InfinispanClientUtil.isDefault(infinispanClientName)) {
            return this.defaultInfinispanClient();
        }
        return this.namedInfinispanClients().get(infinispanClientName);
    }
}

