/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.common.runtime;

import io.quarkus.hibernate.orm.panache.common.ProjectedFieldName;
import io.quarkus.hibernate.orm.panache.common.runtime.AbstractJpaOperations;
import io.quarkus.hibernate.orm.panache.common.runtime.NamedQueryUtil;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Range;
import io.quarkus.panache.common.exception.PanacheQueryException;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Query;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.Filter;
import org.hibernate.Session;

public class CommonPanacheQueryImpl<Entity> {
    private static final NonThrowingCloseable NO_FILTERS = new NonThrowingCloseable(){

        @Override
        public void close() {
        }
    };
    private Object paramsArrayOrMap;
    private String query;
    private String originalQuery;
    protected String countQuery;
    private String orderBy;
    private EntityManager em;
    private Page page;
    private Long count;
    private Range range;
    private LockModeType lockModeType;
    private Map<String, Object> hints;
    private Map<String, Map<String, Object>> filters;

    public CommonPanacheQueryImpl(EntityManager em, String query, String originalQuery, String orderBy, Object paramsArrayOrMap) {
        this.em = em;
        this.query = query;
        this.originalQuery = originalQuery;
        this.orderBy = orderBy;
        this.paramsArrayOrMap = paramsArrayOrMap;
    }

    private CommonPanacheQueryImpl(CommonPanacheQueryImpl<?> previousQuery, String newQueryString, String countQuery) {
        this.em = previousQuery.em;
        this.query = newQueryString;
        this.countQuery = countQuery;
        this.orderBy = previousQuery.orderBy;
        this.paramsArrayOrMap = previousQuery.paramsArrayOrMap;
        this.page = previousQuery.page;
        this.count = previousQuery.count;
        this.range = previousQuery.range;
        this.lockModeType = previousQuery.lockModeType;
        this.hints = previousQuery.hints;
        this.filters = previousQuery.filters;
    }

    public <T> CommonPanacheQueryImpl<T> project(Class<T> type) {
        String lowerCasedTrimmedQuery;
        String selectQuery = this.query;
        if (PanacheJpaUtil.isNamedQuery((String)this.query)) {
            org.hibernate.query.Query q = (org.hibernate.query.Query)this.em.createNamedQuery(this.query.substring(1));
            selectQuery = q.getQueryString();
        }
        if ((lowerCasedTrimmedQuery = selectQuery.trim().replace('\n', ' ').replace('\r', ' ').toLowerCase()).startsWith("select new ") || lowerCasedTrimmedQuery.startsWith("select distinct new ")) {
            throw new PanacheQueryException("Unable to perform a projection on a 'select [distinct]? new' query: " + this.query);
        }
        if (lowerCasedTrimmedQuery.startsWith("select ")) {
            int endSelect = lowerCasedTrimmedQuery.indexOf(" from ");
            String trimmedQuery = selectQuery.trim().replace('\n', ' ').replace('\r', ' ');
            String selectClause = trimmedQuery.substring(7, endSelect).trim();
            String from = trimmedQuery.substring(endSelect);
            StringBuilder newQuery = new StringBuilder("select ");
            boolean distinctQuery = selectClause.toLowerCase().startsWith("distinct ");
            if (distinctQuery) {
                selectClause = selectClause.substring(9).trim();
                newQuery.append("distinct ");
            }
            newQuery.append("new ").append(type.getName()).append("(").append(selectClause).append(")").append(from);
            return new CommonPanacheQueryImpl<Entity>(this, newQuery.toString(), "select count(*) " + from);
        }
        Constructor<?> constructor = type.getDeclaredConstructors()[0];
        StringBuilder select = new StringBuilder("SELECT new ").append(type.getName()).append(" (");
        int selectInitialLength = select.length();
        for (Parameter parameter : constructor.getParameters()) {
            String parameterName;
            if (parameter.isAnnotationPresent(ProjectedFieldName.class)) {
                String name = parameter.getAnnotation(ProjectedFieldName.class).value();
                if (name.isEmpty()) {
                    throw new PanacheQueryException("The annotation ProjectedFieldName must have a non-empty value.");
                }
                parameterName = name;
            } else {
                if (!parameter.isNamePresent()) {
                    throw new PanacheQueryException("Your application must be built with parameter names, this should be the default if using Quarkus project generation. Check the Maven or Gradle compiler configuration to include '-parameters'.");
                }
                parameterName = parameter.getName();
            }
            if (select.length() > selectInitialLength) {
                select.append(", ");
            }
            select.append(parameterName);
        }
        select.append(") ");
        return new CommonPanacheQueryImpl<Entity>(this, select.toString() + selectQuery, "select count(*) " + selectQuery);
    }

    public void filter(String filterName, Map<String, Object> parameters) {
        if (this.filters == null) {
            this.filters = new HashMap<String, Map<String, Object>>();
        }
        this.filters.put(filterName, parameters);
    }

    public void page(Page page) {
        this.page = page;
        this.range = null;
    }

    public void page(int pageIndex, int pageSize) {
        this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    public void nextPage() {
        this.checkPagination();
        this.page(this.page.next());
    }

    public void previousPage() {
        this.checkPagination();
        this.page(this.page.previous());
    }

    public void firstPage() {
        this.checkPagination();
        this.page(this.page.first());
    }

    public void lastPage() {
        this.checkPagination();
        this.page(this.page.index(this.pageCount() - 1));
    }

    public boolean hasNextPage() {
        this.checkPagination();
        return this.page.index < this.pageCount() - 1;
    }

    public boolean hasPreviousPage() {
        this.checkPagination();
        return this.page.index > 0;
    }

    public int pageCount() {
        this.checkPagination();
        long count = this.count();
        if (count == 0L) {
            return 1;
        }
        return (int)Math.ceil((double)count / (double)this.page.size);
    }

    public Page page() {
        this.checkPagination();
        return this.page;
    }

    private void checkPagination() {
        if (this.page == null) {
            throw new UnsupportedOperationException("Cannot call a page related method, call page(Page) or page(int, int) to initiate pagination first");
        }
        if (this.range != null) {
            throw new UnsupportedOperationException("Cannot call a page related method in a ranged query, call page(Page) or page(int, int) to initiate pagination first");
        }
    }

    public void range(int startIndex, int lastIndex) {
        this.range = Range.of((int)startIndex, (int)lastIndex);
        this.page = null;
    }

    public void withLock(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public void withHint(String hintName, Object value) {
        if (this.hints == null) {
            this.hints = new HashMap<String, Object>();
        }
        this.hints.put(hintName, value);
    }

    public long count() {
        if (this.count == null) {
            String selectQuery = this.query;
            if (PanacheJpaUtil.isNamedQuery((String)this.query)) {
                org.hibernate.query.Query q = (org.hibernate.query.Query)this.em.createNamedQuery(this.query.substring(1));
                selectQuery = q.getQueryString();
            }
            Query countQuery = this.em.createQuery(this.countQuery(selectQuery));
            if (this.paramsArrayOrMap instanceof Map) {
                AbstractJpaOperations.bindParameters(countQuery, (Map)this.paramsArrayOrMap);
            } else {
                AbstractJpaOperations.bindParameters(countQuery, (Object[])this.paramsArrayOrMap);
            }
            try (NonThrowingCloseable c = this.applyFilters();){
                this.count = (Long)countQuery.getSingleResult();
            }
        }
        return this.count;
    }

    private String countQuery(String selectQuery) {
        if (this.countQuery != null) {
            return this.countQuery;
        }
        return PanacheJpaUtil.getCountQuery((String)selectQuery);
    }

    public <T extends Entity> List<T> list() {
        Query jpaQuery = this.createQuery();
        try (NonThrowingCloseable c = this.applyFilters();){
            List list = jpaQuery.getResultList();
            return list;
        }
    }

    public <T extends Entity> Stream<T> stream() {
        Query jpaQuery = this.createQuery();
        try (NonThrowingCloseable c = this.applyFilters();){
            Stream stream = jpaQuery.getResultStream();
            return stream;
        }
    }

    public <T extends Entity> T firstResult() {
        Query jpaQuery = this.createQuery(1);
        try (NonThrowingCloseable c = this.applyFilters();){
            List list = jpaQuery.getResultList();
            T t = list.isEmpty() ? null : (T)list.get(0);
            return t;
        }
    }

    public <T extends Entity> Optional<T> firstResultOptional() {
        return Optional.ofNullable(this.firstResult());
    }

    public <T extends Entity> T singleResult() {
        Query jpaQuery = this.createQuery();
        try (NonThrowingCloseable c = this.applyFilters();){
            Object object = jpaQuery.getSingleResult();
            return (T)object;
        }
    }

    public <T extends Entity> Optional<T> singleResultOptional() {
        Query jpaQuery = this.createQuery(2);
        try (NonThrowingCloseable c = this.applyFilters();){
            List list = jpaQuery.getResultList();
            if (list.size() > 1) {
                throw new NonUniqueResultException();
            }
            Optional optional = list.isEmpty() ? Optional.empty() : Optional.of(list.get(0));
            return optional;
        }
    }

    private Query createQuery() {
        Query jpaQuery = this.createBaseQuery();
        if (this.range != null) {
            jpaQuery.setFirstResult(this.range.getStartIndex());
            jpaQuery.setMaxResults(this.range.getLastIndex() - this.range.getStartIndex() + 1);
        } else if (this.page != null) {
            jpaQuery.setFirstResult(this.page.index * this.page.size);
            jpaQuery.setMaxResults(this.page.size);
        }
        return jpaQuery;
    }

    private Query createQuery(int maxResults) {
        Query jpaQuery = this.createBaseQuery();
        if (this.range != null) {
            jpaQuery.setFirstResult(this.range.getStartIndex());
        } else if (this.page != null) {
            jpaQuery.setFirstResult(this.page.index * this.page.size);
        }
        jpaQuery.setMaxResults(maxResults);
        return jpaQuery;
    }

    private Query createBaseQuery() {
        Query jpaQuery;
        if (PanacheJpaUtil.isNamedQuery((String)this.query)) {
            String namedQuery = this.query.substring(1);
            jpaQuery = this.em.createNamedQuery(namedQuery);
        } else {
            try {
                jpaQuery = this.em.createQuery((String)(this.orderBy != null ? this.query + this.orderBy : this.query));
            }
            catch (IllegalArgumentException x) {
                throw NamedQueryUtil.checkForNamedQueryMistake(x, this.originalQuery);
            }
        }
        if (this.paramsArrayOrMap instanceof Map) {
            AbstractJpaOperations.bindParameters(jpaQuery, (Map)this.paramsArrayOrMap);
        } else {
            AbstractJpaOperations.bindParameters(jpaQuery, (Object[])this.paramsArrayOrMap);
        }
        if (this.lockModeType != null) {
            jpaQuery.setLockMode(this.lockModeType);
        }
        if (this.hints != null) {
            for (Map.Entry<String, Object> hint : this.hints.entrySet()) {
                jpaQuery.setHint(hint.getKey(), hint.getValue());
            }
        }
        return jpaQuery;
    }

    private NonThrowingCloseable applyFilters() {
        if (this.filters == null) {
            return NO_FILTERS;
        }
        final Session session = (Session)this.em.unwrap(Session.class);
        for (Map.Entry<String, Map<String, Object>> entry : this.filters.entrySet()) {
            Filter filter = session.enableFilter(entry.getKey());
            for (Map.Entry<String, Object> paramEntry : entry.getValue().entrySet()) {
                if (paramEntry.getValue() instanceof Collection) {
                    filter.setParameterList(paramEntry.getKey(), (Collection)paramEntry.getValue());
                    continue;
                }
                if (paramEntry.getValue() instanceof Object[]) {
                    filter.setParameterList(paramEntry.getKey(), (Object[])paramEntry.getValue());
                    continue;
                }
                filter.setParameter(paramEntry.getKey(), paramEntry.getValue());
            }
            filter.validate();
        }
        return new NonThrowingCloseable(){

            @Override
            public void close() {
                for (Map.Entry<String, Map<String, Object>> entry : CommonPanacheQueryImpl.this.filters.entrySet()) {
                    session.disableFilter(entry.getKey());
                }
            }
        };
    }

    private static interface NonThrowingCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

