/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.common.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.panache.common.runtime.NamedQueryUtil;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.Session;

public abstract class AbstractJpaOperations<PanacheQueryType> {
    private static volatile Map<String, String> entityToPersistenceUnit = Collections.emptyMap();

    public static void setEntityToPersistenceUnit(Map<String, String> map) {
        entityToPersistenceUnit = Collections.unmodifiableMap(map);
    }

    protected abstract PanacheQueryType createPanacheQuery(EntityManager var1, String var2, String var3, String var4, Object var5);

    public abstract List<?> list(PanacheQueryType var1);

    public abstract Stream<?> stream(PanacheQueryType var1);

    public EntityManager getEntityManager(Class<?> clazz) {
        String clazzName = clazz.getName();
        String persistentUnitName = entityToPersistenceUnit.get(clazzName);
        return this.getEntityManager(persistentUnitName);
    }

    public EntityManager getEntityManager(String persistentUnitName) {
        ArcContainer arcContainer = Arc.container();
        if (persistentUnitName == null || PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistentUnitName)) {
            InstanceHandle emHandle = arcContainer.instance(EntityManager.class, new Annotation[0]);
            if (emHandle.isAvailable()) {
                return (EntityManager)emHandle.get();
            }
            if (!arcContainer.instance(AgroalDataSource.class, new Annotation[0]).isAvailable()) {
                throw new IllegalStateException("The default datasource has not been properly configured. See https://quarkus.io/guides/datasource#jdbc-datasource for information on how to do that.");
            }
            throw new IllegalStateException("No entities were found. Did you forget to annotate your Panache Entity classes with '@Entity'?");
        }
        InstanceHandle emHandle = arcContainer.instance(EntityManager.class, new Annotation[]{new PersistenceUnit.PersistenceUnitLiteral(persistentUnitName)});
        if (emHandle.isAvailable()) {
            return (EntityManager)emHandle.get();
        }
        if (!arcContainer.instance(AgroalDataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(persistentUnitName)}).isAvailable()) {
            throw new IllegalStateException("The named datasource '" + persistentUnitName + "' has not been properly configured. See https://quarkus.io/guides/datasource#multiple-datasources for information on how to do that.");
        }
        throw new IllegalStateException("No entities were attached to persistence unit '" + persistentUnitName + "'. Did you forget to annotate your Panache Entity classes with '@Entity' or improperly configure the 'quarkus.hibernate-orm.\" " + persistentUnitName + "\".packages' property?");
    }

    public EntityManager getEntityManager() {
        return this.getEntityManager("<default>");
    }

    public void persist(Object entity) {
        EntityManager em = this.getEntityManager(entity.getClass());
        this.persist(em, entity);
    }

    public void persist(EntityManager em, Object entity) {
        if (!em.contains(entity)) {
            em.persist(entity);
        }
    }

    public void persist(Iterable<?> entities) {
        for (Object entity : entities) {
            this.persist(this.getEntityManager(entity.getClass()), entity);
        }
    }

    public void persist(Object firstEntity, Object ... entities) {
        this.persist(firstEntity);
        for (Object entity : entities) {
            this.persist(entity);
        }
    }

    public void persist(Stream<?> entities) {
        entities.forEach(entity -> this.persist(entity));
    }

    public void delete(Object entity) {
        EntityManager em;
        em.remove((em = this.getEntityManager(entity.getClass())).contains(entity) ? entity : ((Session)em.unwrap(Session.class)).getReference(entity));
    }

    public boolean isPersistent(Object entity) {
        return this.getEntityManager(entity.getClass()).contains(entity);
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public void flush(Object entity) {
        this.getEntityManager(entity.getClass()).flush();
    }

    public void flush(Class<?> clazz) {
        this.getEntityManager(clazz).flush();
    }

    public static TransactionManager getTransactionManager() {
        return (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
    }

    public static Query bindParameters(Query query, Object[] params) {
        if (params == null || params.length == 0) {
            return query;
        }
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
        return query;
    }

    public static Query bindParameters(Query query, Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return query;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    public int paramCount(Object[] params) {
        return params != null ? params.length : 0;
    }

    public int paramCount(Map<String, Object> params) {
        return params != null ? params.size() : 0;
    }

    public Object findById(Class<?> entityClass, Object id) {
        return this.getEntityManager(entityClass).find(entityClass, id);
    }

    public Object findById(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return this.getEntityManager(entityClass).find(entityClass, id, lockModeType);
    }

    public Optional<?> findByIdOptional(Class<?> entityClass, Object id) {
        return Optional.ofNullable(this.findById(entityClass, id));
    }

    public Optional<?> findByIdOptional(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return Optional.ofNullable(this.findById(entityClass, id, lockModeType));
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Object ... params) {
        return this.find(entityClass, query, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Sort sort, Object ... params) {
        EntityManager em = this.getEntityManager(entityClass);
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            String namedQuery = panacheQuery.substring(1);
            if (sort != null) {
                throw new IllegalArgumentException("Sort cannot be used with named query, add an \"order by\" clause to the named query \"" + namedQuery + "\" instead");
            }
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(em, panacheQuery, panacheQuery, null, params);
        }
        String translatedHqlQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
        return this.createPanacheQuery(em, translatedHqlQuery, panacheQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        return this.find(entityClass, panacheQuery, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Sort sort, Map<String, Object> params) {
        EntityManager em = this.getEntityManager(entityClass);
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            String namedQuery = panacheQuery.substring(1);
            if (sort != null) {
                throw new IllegalArgumentException("Sort cannot be used with named query, add an \"order by\" clause to the named query \"" + namedQuery + "\" instead");
            }
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(em, panacheQuery, panacheQuery, null, params);
        }
        String translatedHqlQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
        return this.createPanacheQuery(em, translatedHqlQuery, panacheQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Parameters params) {
        return this.find(entityClass, panacheQuery, (Sort)null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Sort sort, Parameters params) {
        return this.find(entityClass, panacheQuery, sort, params.map());
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Object ... params) {
        return this.list(this.find(entityClass, panacheQuery, params));
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Sort sort, Object ... params) {
        return this.list(this.find(entityClass, panacheQuery, sort, params));
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        return this.list(this.find(entityClass, panacheQuery, params));
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Sort sort, Map<String, Object> params) {
        return this.list(this.find(entityClass, panacheQuery, sort, params));
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Parameters params) {
        return this.list(this.find(entityClass, panacheQuery, params));
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Sort sort, Parameters params) {
        return this.list(this.find(entityClass, panacheQuery, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Object ... params) {
        return this.stream(this.find(entityClass, panacheQuery, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Sort sort, Object ... params) {
        return this.stream(this.find(entityClass, panacheQuery, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        return this.stream(this.find(entityClass, panacheQuery, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Sort sort, Map<String, Object> params) {
        return this.stream(this.find(entityClass, panacheQuery, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Parameters params) {
        return this.stream(this.find(entityClass, panacheQuery, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Sort sort, Parameters params) {
        return this.stream(this.find(entityClass, panacheQuery, sort, params));
    }

    public PanacheQueryType findAll(Class<?> entityClass) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        EntityManager em = this.getEntityManager(entityClass);
        return this.createPanacheQuery(em, query, null, null, null);
    }

    public PanacheQueryType findAll(Class<?> entityClass, Sort sort) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        EntityManager em = this.getEntityManager(entityClass);
        return this.createPanacheQuery(em, query, null, PanacheJpaUtil.toOrderBy((Sort)sort), null);
    }

    public List<?> listAll(Class<?> entityClass) {
        return this.list(this.findAll(entityClass));
    }

    public List<?> listAll(Class<?> entityClass, Sort sort) {
        return this.list(this.findAll(entityClass, sort));
    }

    public Stream<?> streamAll(Class<?> entityClass) {
        return this.stream(this.findAll(entityClass));
    }

    public Stream<?> streamAll(Class<?> entityClass, Sort sort) {
        return this.stream(this.findAll(entityClass, sort));
    }

    public long count(Class<?> entityClass) {
        return (Long)this.getEntityManager(entityClass).createQuery("SELECT COUNT(*) FROM " + PanacheJpaUtil.getEntityName(entityClass)).getSingleResult();
    }

    public long count(Class<?> entityClass, String panacheQuery, Object ... params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            Query namedQuery = this.extractNamedQuery(entityClass, panacheQuery);
            return (Long)AbstractJpaOperations.bindParameters(namedQuery, params).getSingleResult();
        }
        try {
            return (Long)AbstractJpaOperations.bindParameters(this.getEntityManager(entityClass).createQuery(PanacheJpaUtil.createCountQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params))), params).getSingleResult();
        }
        catch (IllegalArgumentException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public long count(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            Query namedQuery = this.extractNamedQuery(entityClass, panacheQuery);
            return (Long)AbstractJpaOperations.bindParameters(namedQuery, params).getSingleResult();
        }
        try {
            return (Long)AbstractJpaOperations.bindParameters(this.getEntityManager(entityClass).createQuery(PanacheJpaUtil.createCountQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params))), params).getSingleResult();
        }
        catch (IllegalArgumentException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public long count(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params.map());
    }

    private Query extractNamedQuery(Class<?> entityClass, String query) {
        if (!PanacheJpaUtil.isNamedQuery((String)query)) {
            throw new IllegalArgumentException("Must be a named query!");
        }
        String namedQueryName = query.substring(1);
        NamedQueryUtil.checkNamedQuery(entityClass, namedQueryName);
        return this.getEntityManager(entityClass).createNamedQuery(namedQueryName);
    }

    public boolean exists(Class<?> entityClass) {
        return this.count(entityClass) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Object ... params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public long deleteAll(Class<?> entityClass) {
        return this.getEntityManager(entityClass).createQuery("DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass)).executeUpdate();
    }

    public boolean deleteById(Class<?> entityClass, Object id) {
        Object entity = this.findById(entityClass, id);
        if (entity == null) {
            return false;
        }
        this.getEntityManager(entityClass).remove(entity);
        return true;
    }

    public long delete(Class<?> entityClass, String panacheQuery, Object ... params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            Query namedQuery = this.extractNamedQuery(entityClass, panacheQuery);
            return AbstractJpaOperations.bindParameters(namedQuery, params).executeUpdate();
        }
        try {
            return AbstractJpaOperations.bindParameters(this.getEntityManager(entityClass).createQuery(PanacheJpaUtil.createDeleteQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params))), params).executeUpdate();
        }
        catch (IllegalArgumentException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public long delete(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            Query namedQuery = this.extractNamedQuery(entityClass, panacheQuery);
            return AbstractJpaOperations.bindParameters(namedQuery, params).executeUpdate();
        }
        try {
            return AbstractJpaOperations.bindParameters(this.getEntityManager(entityClass).createQuery(PanacheJpaUtil.createDeleteQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params))), params).executeUpdate();
        }
        catch (IllegalArgumentException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public long delete(Class<?> entityClass, String query, Parameters params) {
        return this.delete(entityClass, query, params.map());
    }

    public static IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses: did you forget to annotate your entity with @Entity?");
    }

    public int executeUpdate(String query, Object ... params) {
        Query jpaQuery = this.getEntityManager("<default>").createQuery(query);
        AbstractJpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public int executeUpdate(String query, Map<String, Object> params) {
        Query jpaQuery = this.getEntityManager("<default>").createQuery(query);
        AbstractJpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public int executeUpdate(Class<?> entityClass, String panacheQuery, Object ... params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            Query namedQuery = this.extractNamedQuery(entityClass, panacheQuery);
            return AbstractJpaOperations.bindParameters(namedQuery, params).executeUpdate();
        }
        try {
            String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
            Query jpaQuery = this.getEntityManager(entityClass).createQuery(updateQuery);
            AbstractJpaOperations.bindParameters(jpaQuery, params);
            return jpaQuery.executeUpdate();
        }
        catch (IllegalArgumentException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public int executeUpdate(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            Query namedQuery = this.extractNamedQuery(entityClass, panacheQuery);
            return AbstractJpaOperations.bindParameters(namedQuery, params).executeUpdate();
        }
        try {
            String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
            Query jpaQuery = this.getEntityManager(entityClass).createQuery(updateQuery);
            AbstractJpaOperations.bindParameters(jpaQuery, params);
            return jpaQuery.executeUpdate();
        }
        catch (IllegalArgumentException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public int update(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public int update(Class<?> entityClass, String query, Parameters params) {
        return this.update(entityClass, query, params.map());
    }

    public int update(Class<?> entityClass, String query, Object ... params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public static void setRollbackOnly() {
        try {
            AbstractJpaOperations.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException e) {
            throw new IllegalStateException(e);
        }
    }
}

