/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing;

import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class WrapperRunner {
    public static int run(Path projectDir) {
        return WrapperRunner.run(projectDir, Wrapper.detect(projectDir));
    }

    public static int run(Path projectDir, Wrapper wrapper) {
        String mavenSettings;
        LinkedList<String> command = new LinkedList<String>();
        command.add(projectDir.resolve(wrapper.getExec()).toAbsolutePath().toString());
        command.addAll(Arrays.asList(wrapper.getCmdArgs()));
        WrapperRunner.propagateSystemPropertyIfSet("maven.repo.local", command);
        if (wrapper == Wrapper.MAVEN && (mavenSettings = WrapperRunner.getMavenSettingsArg()) != null) {
            command.add("-s");
            command.add(mavenSettings);
        }
        try {
            System.out.println("Running command: " + String.valueOf(command));
            Process p = new ProcessBuilder(new String[0]).directory(projectDir.toFile()).command(command).start();
            try {
                WrapperRunner.streamToSysOutSysErr(p);
                p.waitFor(10L, TimeUnit.MINUTES);
                return p.exitValue();
            }
            catch (InterruptedException e) {
                p.destroyForcibly();
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return -1;
    }

    private static String getMavenSettingsArg() {
        String mavenSettings = System.getProperty("maven.settings");
        if (mavenSettings != null) {
            return Files.exists(Paths.get(mavenSettings, new String[0]), new LinkOption[0]) ? mavenSettings : null;
        }
        return BootstrapMavenOptions.newInstance().getOptionValue("s");
    }

    private static void propagateSystemPropertyIfSet(String name, List<String> command) {
        if (System.getProperties().containsKey(name)) {
            StringBuilder buf = new StringBuilder();
            buf.append("-D").append(name);
            String value = System.getProperty(name);
            if (value != null && !value.isEmpty()) {
                buf.append("=").append(value);
            }
            command.add(buf.toString());
        }
    }

    private static void streamToSysOutSysErr(Process process) {
        WrapperRunner.streamOutputToSysOut(process);
        WrapperRunner.streamErrorToSysErr(process);
    }

    private static void streamOutputToSysOut(Process process) {
        InputStream processStdOut = process.getInputStream();
        Thread t = new Thread(new Streamer(processStdOut, System.out));
        t.setName("Process stdout streamer");
        t.setDaemon(true);
        t.start();
    }

    private static void streamErrorToSysErr(Process process) {
        WrapperRunner.streamErrorTo(System.err, process);
    }

    private static void streamErrorTo(PrintStream printStream, Process process) {
        InputStream processStdErr = process.getErrorStream();
        Thread t = new Thread(new Streamer(processStdErr, printStream));
        t.setName("Process stderr streamer");
        t.setDaemon(true);
        t.start();
    }

    public static enum Wrapper {
        GRADLE("gradlew", "gradlew.bat", new String[]{"--no-daemon", "build", "--info", "--stacktrace"}),
        MAVEN("mvnw", "mvnw.cmd", new String[]{"-B", "package"});

        private final String execUnix;
        private final String execWindows;
        private final String[] cmdArgs;

        private Wrapper(String execUnix, String execWindows, String[] cmdArgs) {
            this.execUnix = execUnix;
            this.execWindows = execWindows;
            this.cmdArgs = cmdArgs;
        }

        public String getExec() {
            return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows") ? this.execWindows : this.execUnix;
        }

        public String[] getCmdArgs() {
            return this.cmdArgs;
        }

        public static Wrapper fromBuildtool(String buildtool) {
            switch (buildtool) {
                case "maven": {
                    return MAVEN;
                }
                case "gradle": 
                case "gradle-kotlin-dsl": {
                    return GRADLE;
                }
            }
            throw new IllegalStateException("No wrapper linked to build tool: " + buildtool);
        }

        public static Wrapper detect(Path projectDir) {
            for (Wrapper value : Wrapper.values()) {
                File file = projectDir.resolve(value.getExec()).toFile();
                if (!file.isFile() || !file.canExecute()) continue;
                return value;
            }
            throw new IllegalStateException("No supported wrapper that can be executed found in this directory: " + String.valueOf(projectDir));
        }
    }

    private static final class Streamer
    implements Runnable {
        private final InputStream processStream;
        private final PrintStream consumer;

        private Streamer(InputStream processStream, PrintStream consumer) {
            this.processStream = processStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.processStream, StandardCharsets.UTF_8));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.consumer.println(line);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

