/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.registry.config.RegistryMavenRepoConfig;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class RegistryMavenRepoConfigImpl
implements RegistryMavenRepoConfig {
    private final String id;
    private final String url;

    private RegistryMavenRepoConfigImpl(String id, String url) {
        this.id = id;
        this.url = url;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistryMavenRepoConfigImpl that = (RegistryMavenRepoConfigImpl)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url);
    }

    public String toString() {
        return "BaseRegistryMavenRepoConfig{id='" + this.id + "', url='" + this.url + "'}";
    }

    public static class Builder
    implements RegistryMavenRepoConfig.Mutable {
        protected String id;
        protected String url;

        public Builder() {
        }

        @JsonIgnore
        Builder(RegistryMavenRepoConfig config) {
            this.id = config.getId();
            this.url = config.getUrl();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        @Override
        public RegistryMavenRepoConfigImpl build() {
            return new RegistryMavenRepoConfigImpl(this.id, this.url);
        }
    }
}

