/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import java.nio.file.Path;

public interface ConfigSource {
    public static final ConfigSource DEFAULT = new ConfigSource(){

        @Override
        public Path getFilePath() {
            return null;
        }

        @Override
        public String describe() {
            return "default configuration";
        }
    };
    public static final ConfigSource MANUAL = new ConfigSource(){

        @Override
        public Path getFilePath() {
            return null;
        }

        @Override
        public String describe() {
            return "manually configured (programmatic)";
        }
    };
    public static final ConfigSource ENV = new ConfigSource(){

        @Override
        public Path getFilePath() {
            return null;
        }

        @Override
        public String describe() {
            return String.format("environment variables: registries defined in %s, with supporting configuration in variables prefixed with %s", "QUARKUS_REGISTRIES", "QUARKUS_REGISTRY_");
        }
    };

    public Path getFilePath();

    public String describe();

    public static class FileConfigSource
    implements ConfigSource {
        final Path configFile;

        public FileConfigSource(Path configFile) {
            this.configFile = configFile;
        }

        @Override
        public Path getFilePath() {
            return this.configFile;
        }

        @Override
        public String describe() {
            return String.format("file: %s", this.configFile);
        }
    }
}

