/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.deployment.pkg.jar.Decompiler;
import io.smallrye.common.process.ProcessBuilder;
import io.smallrye.common.process.ProcessUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jboss.logging.Logger;

class VineflowerDecompiler
implements Decompiler {
    private static final Logger LOG = Logger.getLogger(VineflowerDecompiler.class);
    private static final String DEFAULT_VINEFLOWER_VERSION = "1.11.1";
    private Decompiler.Context context;
    private Path decompilerJar;

    VineflowerDecompiler() {
    }

    @Override
    public void init(Decompiler.Context context) {
        this.context = context;
        this.decompilerJar = context.jarLocation.resolve(String.format("vineflower-%s.jar", context.versionStr != null ? context.versionStr : DEFAULT_VINEFLOWER_VERSION));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean downloadIfNecessary() {
        if (Files.exists(this.decompilerJar, new LinkOption[0])) {
            return true;
        }
        String downloadURL = String.format("https://repo.maven.apache.org/maven2/org/vineflower/vineflower/%s/vineflower-%s.jar", this.context.versionStr, this.context.versionStr);
        try (BufferedInputStream in = new BufferedInputStream(new URL(downloadURL).openStream());){
            boolean bl;
            block14: {
                OutputStream fileOutputStream = Files.newOutputStream(this.decompilerJar, new OpenOption[0]);
                try {
                    in.transferTo(fileOutputStream);
                    bl = true;
                    if (fileOutputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fileOutputStream.close();
            }
            return bl;
        }
        catch (IOException e) {
            LOG.error((Object)("Unable to download Vineflower from " + downloadURL), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean decompile(Path jarToDecompile) {
        String jarFileName = jarToDecompile.getFileName().toString();
        int dotIndex = jarFileName.indexOf(46);
        String outputDirectory = jarFileName.substring(0, dotIndex);
        ProcessBuilder pb = ProcessBuilder.newBuilder((Path)ProcessUtil.pathOfJava()).arguments(new String[]{"-jar", this.decompilerJar.toAbsolutePath().toString(), "-rsy=0", "-rbr=0", jarToDecompile.toAbsolutePath().toString(), this.context.decompiledOutputDir.resolve(outputDirectory).toAbsolutePath().toString()});
        if (LOG.isDebugEnabled()) {
            pb.output().consumeLinesWith(8192, arg_0 -> ((Logger)LOG).debug(arg_0));
        }
        try {
            pb.run();
        }
        catch (Exception e) {
            LOG.error((Object)"Decompilation failed", (Throwable)e);
            return false;
        }
        return true;
    }
}

