/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.devmode;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;

public class DependenciesFilter {
    private static final Logger log = Logger.getLogger(DependenciesFilter.class);

    public static List<WorkspaceModule> getReloadableModules(ApplicationModel appModel) {
        ArrayList<WorkspaceModule> reloadable = new ArrayList<WorkspaceModule>();
        if (appModel.getApplicationModule() != null) {
            reloadable.add(appModel.getApplicationModule());
        }
        appModel.getDependencies().forEach(d -> {
            WorkspaceModule module = d.getWorkspaceModule();
            if (module != null) {
                if (d.isReloadable()) {
                    reloadable.add(module);
                } else {
                    log.warn((Object)("Local Quarkus extension dependency " + module.getId() + " will not be hot-reloadable"));
                }
            }
        });
        return reloadable;
    }
}

