/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http;

import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import io.quarkus.amazon.lambda.http.LambdaHttpRecorder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class CognitoPrincipal
implements JsonWebToken {
    private APIGatewayV2HTTPEvent.RequestContext.Authorizer.JWT jwt;
    private String name;
    private Set<String> groups;

    public CognitoPrincipal(APIGatewayV2HTTPEvent.RequestContext.Authorizer.JWT jwt) {
        this.jwt = jwt;
        this.name = (String)jwt.getClaims().get("cognito:username");
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getClaimNames() {
        return this.getClaims().getClaims().keySet();
    }

    public <T> T getClaim(String claimName) {
        if (claimName.equals(Claims.groups)) {
            return (T)this.getGroups();
        }
        if (claimName.equals(Claims.groups)) {
            return (T)this.getAudience();
        }
        if (claimName.equals(Claims.exp)) {
            return (T)Long.valueOf(this.getExpirationTime());
        }
        if (claimName.equals(Claims.iat)) {
            return (T)Long.valueOf(this.getIssuedAtTime());
        }
        if (claimName.equals(Claims.aud)) {
            return (T)this.getAudience();
        }
        return (T)this.getClaims().getClaims().get(claimName);
    }

    public Set<String> getAudience() {
        return Collections.EMPTY_SET;
    }

    public long getExpirationTime() {
        String val = (String)this.jwt.getClaims().get(Claims.exp);
        if (val == null) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    public long getIssuedAtTime() {
        String val = (String)this.jwt.getClaims().get(Claims.iat);
        if (val == null) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    public Set<String> getGroups() {
        if (this.groups == null) {
            if (this.jwt.getClaims().containsKey(LambdaHttpRecorder.config.cognitoRoleClaim)) {
                String claim = (String)this.jwt.getClaims().get(LambdaHttpRecorder.config.cognitoRoleClaim);
                Matcher matcher = LambdaHttpRecorder.groupPattern.matcher(claim);
                this.groups = new HashSet<String>();
                while (matcher.find()) {
                    this.groups.add(matcher.group(matcher.groupCount()));
                }
            } else {
                this.groups = Collections.EMPTY_SET;
            }
        }
        return this.groups;
    }

    public APIGatewayV2HTTPEvent.RequestContext.Authorizer.JWT getClaims() {
        return this.jwt;
    }
}

