/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BuildExtension;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.logging.Logger;

abstract class AnnotationsTransformationContext<C extends Collection<AnnotationInstance>>
implements BuildExtension.BuildContext {
    private static final Logger LOG = Logger.getLogger(AnnotationsTransformationContext.class);
    protected final BuildExtension.BuildContext buildContext;
    protected final AnnotationTarget target;
    private C annotations;

    public AnnotationsTransformationContext(BuildExtension.BuildContext buildContext, AnnotationTarget target, C annotations) {
        this.buildContext = buildContext;
        this.target = target;
        this.annotations = annotations;
    }

    @Override
    public <V> V get(BuildExtension.Key<V> key) {
        return this.buildContext.get(key);
    }

    @Override
    public <V> V put(BuildExtension.Key<V> key, V value) {
        return this.buildContext.put(key, value);
    }

    public AnnotationTarget getTarget() {
        return this.target;
    }

    public C getAnnotations() {
        return this.annotations;
    }

    void setAnnotations(C annotations) {
        LOG.tracef("Annotations of %s transformed: %s", (Object)this.target, annotations);
        this.annotations = annotations;
    }

    public Collection<AnnotationInstance> getAllAnnotations() {
        AnnotationStore annotationStore = this.get(BuildExtension.Key.ANNOTATION_STORE);
        if (annotationStore == null) {
            throw new IllegalStateException("Attempted to use the getAllAnnotations() method but AnnotationStore wasn't initialized.");
        }
        return annotationStore.getAnnotations(this.getTarget());
    }
}

