/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mailpit.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@Recorder
public class MailpitUiProxy {
    private static final Logger log = Logger.getLogger(MailpitUiProxy.class);

    public Handler<RoutingContext> handler(Supplier<Vertx> vertx) {
        final Optional portOptional = ConfigProvider.getConfig().getOptionalValue("mailpit.http.port", Integer.class);
        final WebClient client = WebClient.create((Vertx)vertx.get());
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                if (!portOptional.isPresent()) {
                    event.response().setStatusCode(404).end();
                    return;
                }
                Integer port = (Integer)portOptional.get();
                HttpRequest r = client.request(event.request().method(), port.intValue(), "localhost", event.request().uri());
                event.request().headers().forEach(h -> r.putHeader((String)h.getKey(), (String)h.getValue()));
                if ("websocket".equals(event.request().getHeader("upgrade"))) {
                    event.request().toWebSocket().onComplete(ws -> {
                        if (ws.succeeded()) {
                            event.request().resume();
                            ((ServerWebSocket)ws.result()).handler(buff -> event.response().write(buff));
                        } else {
                            log.error((Object)"WebSocket failed", ws.cause());
                        }
                    });
                } else {
                    r.sendBuffer(event.body().buffer()).andThen(resp -> {
                        event.response().setStatusCode(((HttpResponse)resp.result()).statusCode());
                        ((HttpResponse)resp.result()).headers().forEach(h -> event.response().putHeader((String)h.getKey(), (String)h.getValue()));
                        event.response().end(((HttpResponse)resp.result()).bodyAsBuffer());
                    });
                }
            }
        };
    }
}

