/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.runtime;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.DisabledChatModel;
import dev.langchain4j.model.chat.DisabledStreamingChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.embedding.DisabledEmbeddingModel;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.scoring.ScoringModel;
import io.quarkiverse.langchain4j.runtime.NamedConfigUtil;
import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkiverse.langchain4j.watsonx.WatsonxChatModel;
import io.quarkiverse.langchain4j.watsonx.WatsonxEmbeddingModel;
import io.quarkiverse.langchain4j.watsonx.WatsonxGenerationModel;
import io.quarkiverse.langchain4j.watsonx.WatsonxGenerationStreamingModel;
import io.quarkiverse.langchain4j.watsonx.WatsonxScoringModel;
import io.quarkiverse.langchain4j.watsonx.WatsonxStreamingChatModel;
import io.quarkiverse.langchain4j.watsonx.client.COSRestApi;
import io.quarkiverse.langchain4j.watsonx.client.WatsonxClientLogger;
import io.quarkiverse.langchain4j.watsonx.client.WatsonxRestApi;
import io.quarkiverse.langchain4j.watsonx.client.filter.BearerTokenHeaderFactory;
import io.quarkiverse.langchain4j.watsonx.runtime.TextExtraction;
import io.quarkiverse.langchain4j.watsonx.runtime.TokenGenerationCache;
import io.quarkiverse.langchain4j.watsonx.runtime.TokenGenerator;
import io.quarkiverse.langchain4j.watsonx.runtime.config.ChatModelConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.EmbeddingModelConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.GenerationModelConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.LangChain4jWatsonxConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.ScoringModelConfig;
import io.quarkiverse.langchain4j.watsonx.runtime.config.TextExtractionConfig;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigValidationException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;

@Recorder
public class WatsonxRecorder {
    private static final ConfigValidationException.Problem[] EMPTY_PROBLEMS = new ConfigValidationException.Problem[0];
    private static final TypeLiteral<Instance<ChatModelListener>> CHAT_MODEL_LISTENER_TYPE_LITERAL = new TypeLiteral<Instance<ChatModelListener>>(){};
    private final RuntimeValue<LangChain4jWatsonxConfig> runtimeConfig;

    public WatsonxRecorder(RuntimeValue<LangChain4jWatsonxConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public Function<SyntheticCreationalContext<ChatModel>, ChatModel> chatModel(String configName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonRuntimeConfig = this.correspondingWatsonRuntimeConfig(configName);
        final String apiKey = (String)OptionalUtil.firstOrDefault(null, (Optional[])new Optional[]{watsonRuntimeConfig.apiKey(), ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().apiKey()});
        if (watsonRuntimeConfig.enableIntegration().booleanValue()) {
            final WatsonxChatModel.Builder builder = this.chatBuilder(configName);
            final URL iamBaseUrl = watsonRuntimeConfig.iam().baseUrl();
            final String granType = watsonRuntimeConfig.iam().grantType();
            final Duration duration = watsonRuntimeConfig.iam().timeout().orElse(Duration.ofSeconds(10L));
            return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(this){
                final /* synthetic */ WatsonxRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                    return ((WatsonxChatModel.Builder)((WatsonxChatModel.Builder)builder.tokenGenerator(TokenGenerationCache.getOrCreateTokenGenerator(apiKey, iamBaseUrl, granType, duration))).listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().toList())).build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(){

            @Override
            public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                return new DisabledChatModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel> streamingChatModel(String configName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonRuntimeConfig = this.correspondingWatsonRuntimeConfig(configName);
        final String apiKey = (String)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().apiKey().orElse(null), (Optional[])new Optional[]{watsonRuntimeConfig.apiKey()});
        if (watsonRuntimeConfig.enableIntegration().booleanValue()) {
            final WatsonxStreamingChatModel.Builder builder = this.streamingChatBuilder(configName);
            final URL iamBaseUrl = watsonRuntimeConfig.iam().baseUrl();
            final String granType = watsonRuntimeConfig.iam().grantType();
            final Duration duration = watsonRuntimeConfig.iam().timeout().orElse(Duration.ofSeconds(10L));
            return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(this){
                final /* synthetic */ WatsonxRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                    return ((WatsonxStreamingChatModel.Builder)((WatsonxStreamingChatModel.Builder)builder.tokenGenerator(TokenGenerationCache.getOrCreateTokenGenerator(apiKey, iamBaseUrl, granType, duration))).listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().toList())).build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(){

            @Override
            public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                return new DisabledStreamingChatModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<ChatModel>, ChatModel> generationModel(String configName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonRuntimeConfig = this.correspondingWatsonRuntimeConfig(configName);
        final String apiKey = (String)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().apiKey().orElse(null), (Optional[])new Optional[]{watsonRuntimeConfig.apiKey()});
        if (watsonRuntimeConfig.enableIntegration().booleanValue()) {
            final WatsonxGenerationModel.Builder builder = this.generationBuilder(configName);
            final URL iamBaseUrl = watsonRuntimeConfig.iam().baseUrl();
            final String granType = watsonRuntimeConfig.iam().grantType();
            final Duration duration = watsonRuntimeConfig.iam().timeout().orElse(Duration.ofSeconds(10L));
            return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(this){
                final /* synthetic */ WatsonxRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                    return ((WatsonxGenerationModel.Builder)((WatsonxGenerationModel.Builder)builder.tokenGenerator(TokenGenerationCache.getOrCreateTokenGenerator(apiKey, iamBaseUrl, granType, duration))).listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().toList())).build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<ChatModel>, ChatModel>(){

            @Override
            public ChatModel apply(SyntheticCreationalContext<ChatModel> context) {
                return new DisabledChatModel();
            }
        };
    }

    public Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel> generationStreamingModel(String configName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonRuntimeConfig = this.correspondingWatsonRuntimeConfig(configName);
        final String apiKey = (String)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().apiKey().orElse(null), (Optional[])new Optional[]{watsonRuntimeConfig.apiKey()});
        if (watsonRuntimeConfig.enableIntegration().booleanValue()) {
            final WatsonxGenerationStreamingModel.Builder builder = this.generationStreamingBuilder(configName);
            final URL iamBaseUrl = watsonRuntimeConfig.iam().baseUrl();
            final String granType = watsonRuntimeConfig.iam().grantType();
            final Duration duration = watsonRuntimeConfig.iam().timeout().orElse(Duration.ofSeconds(10L));
            return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(this){
                final /* synthetic */ WatsonxRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                    return ((WatsonxGenerationStreamingModel.Builder)((WatsonxGenerationStreamingModel.Builder)builder.tokenGenerator(TokenGenerationCache.getOrCreateTokenGenerator(apiKey, iamBaseUrl, granType, duration))).listeners(((Instance)context.getInjectedReference(CHAT_MODEL_LISTENER_TYPE_LITERAL, new Annotation[0])).stream().toList())).build();
                }
            };
        }
        return new Function<SyntheticCreationalContext<StreamingChatModel>, StreamingChatModel>(){

            @Override
            public StreamingChatModel apply(SyntheticCreationalContext<StreamingChatModel> context) {
                return new DisabledStreamingChatModel();
            }
        };
    }

    public Supplier<EmbeddingModel> embeddingModel(String configName) {
        LangChain4jWatsonxConfig.WatsonConfig defaultConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig();
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonRuntimeConfig(configName);
        if (watsonConfig.enableIntegration().booleanValue()) {
            URL url;
            List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(configName);
            if (!configProblems.isEmpty()) {
                throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
            }
            final String apiKey = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.apiKey().orElse(null), (Optional[])new Optional[]{watsonConfig.apiKey()});
            try {
                url = URI.create((String)OptionalUtil.firstOrDefault((Object)defaultConfig.baseUrl().orElse(null), (Optional[])new Optional[]{watsonConfig.baseUrl()})).toURL();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            EmbeddingModelConfig embeddingModelConfig = watsonConfig.embeddingModel();
            Duration timeout = (Duration)OptionalUtil.firstOrDefault((Object)Duration.ofSeconds(10L), (Optional[])new Optional[]{watsonConfig.timeout(), defaultConfig.timeout()});
            Boolean logRequests = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logRequests().orElse(false), (Optional[])new Optional[]{embeddingModelConfig.logRequests(), watsonConfig.logRequests()});
            Boolean logResponses = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logResponses().orElse(false), (Optional[])new Optional[]{embeddingModelConfig.logResponses(), watsonConfig.logResponses()});
            String spaceId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.spaceId().orElse(null), (Optional[])new Optional[]{watsonConfig.spaceId()});
            String projectId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.projectId().orElse(null), (Optional[])new Optional[]{watsonConfig.projectId()});
            final WatsonxEmbeddingModel.Builder builder = ((WatsonxEmbeddingModel.Builder)((WatsonxEmbeddingModel.Builder)((WatsonxEmbeddingModel.Builder)((WatsonxEmbeddingModel.Builder)((WatsonxEmbeddingModel.Builder)((WatsonxEmbeddingModel.Builder)((WatsonxEmbeddingModel.Builder)((WatsonxEmbeddingModel.Builder)WatsonxEmbeddingModel.builder().url(url)).timeout(timeout)).logRequests(logRequests)).logResponses(logResponses)).version(watsonConfig.version())).spaceId(spaceId)).projectId(projectId)).modelId(embeddingModelConfig.modelName())).truncateInputTokens(embeddingModelConfig.truncateInputTokens().orElse(null));
            final URL iamBaseUrl = watsonConfig.iam().baseUrl();
            final String granType = watsonConfig.iam().grantType();
            final Duration duration = watsonConfig.iam().timeout().orElse(Duration.ofSeconds(10L));
            return new Supplier<EmbeddingModel>(this){
                final /* synthetic */ WatsonxRecorder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public WatsonxEmbeddingModel get() {
                    return ((WatsonxEmbeddingModel.Builder)builder.tokenGenerator(TokenGenerationCache.getOrCreateTokenGenerator(apiKey, iamBaseUrl, granType, duration))).build();
                }
            };
        }
        return new Supplier<EmbeddingModel>(){

            @Override
            public EmbeddingModel get() {
                return new DisabledEmbeddingModel();
            }
        };
    }

    public Supplier<ScoringModel> scoringModel(String configName) {
        URL url;
        LangChain4jWatsonxConfig.WatsonConfig defaultConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig();
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonRuntimeConfig(configName);
        List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(configName);
        if (!configProblems.isEmpty()) {
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        final String apiKey = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.apiKey().orElse(null), (Optional[])new Optional[]{watsonConfig.apiKey()});
        try {
            url = URI.create((String)OptionalUtil.firstOrDefault((Object)defaultConfig.baseUrl().orElse(null), (Optional[])new Optional[]{watsonConfig.baseUrl()})).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ScoringModelConfig rerankModelConfig = watsonConfig.scoringModel();
        Duration timeout = (Duration)OptionalUtil.firstOrDefault((Object)Duration.ofSeconds(10L), (Optional[])new Optional[]{watsonConfig.timeout(), defaultConfig.timeout()});
        Boolean logRequests = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logRequests().orElse(false), (Optional[])new Optional[]{rerankModelConfig.logRequests(), watsonConfig.logRequests()});
        Boolean logResponses = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logResponses().orElse(false), (Optional[])new Optional[]{rerankModelConfig.logResponses(), watsonConfig.logResponses()});
        String spaceId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.spaceId().orElse(null), (Optional[])new Optional[]{watsonConfig.spaceId()});
        String projectId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.projectId().orElse(null), (Optional[])new Optional[]{watsonConfig.projectId()});
        final WatsonxScoringModel.Builder builder = ((WatsonxScoringModel.Builder)((WatsonxScoringModel.Builder)((WatsonxScoringModel.Builder)((WatsonxScoringModel.Builder)((WatsonxScoringModel.Builder)((WatsonxScoringModel.Builder)((WatsonxScoringModel.Builder)((WatsonxScoringModel.Builder)WatsonxScoringModel.builder().url(url)).timeout(timeout)).logRequests(logRequests)).logResponses(logResponses)).version(watsonConfig.version())).spaceId(spaceId)).projectId(projectId)).modelId(rerankModelConfig.modelName())).truncateInputTokens(rerankModelConfig.truncateInputTokens().orElse(null));
        final URL iamBaseUrl = watsonConfig.iam().baseUrl();
        final String granType = watsonConfig.iam().grantType();
        final Duration duration = watsonConfig.iam().timeout().orElse(Duration.ofSeconds(10L));
        return new Supplier<ScoringModel>(this){
            final /* synthetic */ WatsonxRecorder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public WatsonxScoringModel get() {
                return ((WatsonxScoringModel.Builder)builder.tokenGenerator(TokenGenerationCache.getOrCreateTokenGenerator(apiKey, iamBaseUrl, granType, duration))).build();
            }
        };
    }

    public Supplier<TextExtraction> textExtraction(String configName) {
        URL watsonxUrl;
        URL cosUrl;
        final LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonRuntimeConfig(configName);
        ArrayList<ConfigValidationException.Problem> configProblems = new ArrayList<ConfigValidationException.Problem>();
        final TextExtractionConfig textExtractionConfig = (TextExtractionConfig)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().textExtraction().orElse(null), (Optional[])new Optional[]{watsonConfig.textExtraction()});
        if (Objects.isNull(textExtractionConfig)) {
            configProblems.add(WatsonxRecorder.createConfigProblem("text-extraction", configName));
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        final String apiKey = (String)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().apiKey().orElse(null), (Optional[])new Optional[]{watsonConfig.apiKey()});
        final URL iamBaseUrl = watsonConfig.iam().baseUrl();
        final String granType = watsonConfig.iam().grantType();
        final Duration iamDuration = watsonConfig.iam().timeout().orElse(Duration.ofSeconds(10L));
        final Duration watsonxDuration = watsonConfig.timeout().orElse(Duration.ofSeconds(10L));
        final boolean logRequests = watsonConfig.logRequests().orElse(false);
        final boolean logResponses = watsonConfig.logResponses().orElse(false);
        try {
            cosUrl = URI.create(textExtractionConfig.baseUrl()).toURL();
            watsonxUrl = URI.create((String)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().baseUrl().orElse(null), (Optional[])new Optional[]{watsonConfig.baseUrl()})).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Supplier<TextExtraction>(){
            final /* synthetic */ WatsonxRecorder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public TextExtraction get() {
                TokenGenerator tokenGenerator = TokenGenerationCache.getOrCreateTokenGenerator(apiKey, iamBaseUrl, granType, iamDuration);
                QuarkusRestClientBuilder watsonxClient = QuarkusRestClientBuilder.newBuilder().baseUrl(watsonxUrl).clientHeadersFactory((ClientHeadersFactory)new BearerTokenHeaderFactory(tokenGenerator)).connectTimeout(watsonxDuration.toSeconds(), TimeUnit.SECONDS).readTimeout(watsonxDuration.toSeconds(), TimeUnit.SECONDS);
                if (logRequests || logResponses) {
                    watsonxClient.loggingScope(LoggingScope.REQUEST_RESPONSE);
                    watsonxClient.clientLogger((ClientLogger)new WatsonxClientLogger(logRequests, logResponses));
                }
                QuarkusRestClientBuilder cosClient = QuarkusRestClientBuilder.newBuilder().baseUrl(cosUrl).clientHeadersFactory((ClientHeadersFactory)new BearerTokenHeaderFactory(tokenGenerator)).connectTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS);
                if (logRequests || logResponses) {
                    cosClient.loggingScope(LoggingScope.REQUEST_RESPONSE);
                    cosClient.clientLogger((ClientLogger)new WatsonxClientLogger(logRequests, logResponses));
                }
                return new TextExtraction(new TextExtraction.Reference(textExtractionConfig.documentReference().connection(), textExtractionConfig.documentReference().bucketName()), new TextExtraction.Reference(textExtractionConfig.resultsReference().connection(), textExtractionConfig.resultsReference().bucketName()), (String)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.this$0.runtimeConfig.getValue()).defaultConfig().projectId().orElse(null), (Optional[])new Optional[]{watsonConfig.projectId()}), (String)OptionalUtil.firstOrDefault((Object)((LangChain4jWatsonxConfig)this.this$0.runtimeConfig.getValue()).defaultConfig().spaceId().orElse(null), (Optional[])new Optional[]{watsonConfig.spaceId()}), watsonConfig.version(), (COSRestApi)cosClient.build(COSRestApi.class), (WatsonxRestApi)watsonxClient.build(WatsonxRestApi.class));
            }
        };
    }

    private WatsonxChatModel.Builder chatBuilder(String configName) {
        String toolChoiceName;
        URL url;
        LangChain4jWatsonxConfig.WatsonConfig defaultConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig();
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonRuntimeConfig(configName);
        List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(configName);
        if (!configProblems.isEmpty()) {
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        ChatModelConfig chatModelConfig = watsonConfig.chatModel();
        try {
            url = URI.create((String)OptionalUtil.firstOrDefault((Object)defaultConfig.baseUrl().orElse(null), (Optional[])new Optional[]{watsonConfig.baseUrl()})).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String responseFormat = null;
        if (chatModelConfig.responseFormat().isPresent()) {
            switch (chatModelConfig.responseFormat().get().toLowerCase()) {
                case "json_object": 
                case "json_schema": 
                case "text": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The value '%s' for the response-format property is not available. Use one of the values: [%s]".formatted(chatModelConfig.responseFormat().get(), "json_object"));
                }
            }
            responseFormat = chatModelConfig.responseFormat().get();
        }
        ToolChoice toolChoice = (toolChoiceName = (String)chatModelConfig.toolChoiceName().orElse(null)) != null ? ToolChoice.REQUIRED : (ToolChoice)chatModelConfig.toolChoice().orElse(null);
        Duration timeout = (Duration)OptionalUtil.firstOrDefault((Object)Duration.ofSeconds(10L), (Optional[])new Optional[]{watsonConfig.timeout(), defaultConfig.timeout()});
        Boolean logRequests = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logRequests().orElse(false), (Optional[])new Optional[]{chatModelConfig.logRequests(), watsonConfig.logRequests()});
        Boolean logResponses = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logResponses().orElse(false), (Optional[])new Optional[]{chatModelConfig.logResponses(), watsonConfig.logResponses()});
        String spaceId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.spaceId().orElse(null), (Optional[])new Optional[]{watsonConfig.spaceId()});
        String projectId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.projectId().orElse(null), (Optional[])new Optional[]{watsonConfig.projectId()});
        return (WatsonxChatModel.Builder)((WatsonxChatModel.Builder)((WatsonxChatModel.Builder)((WatsonxChatModel.Builder)((WatsonxChatModel.Builder)((WatsonxChatModel.Builder)((WatsonxChatModel.Builder)((WatsonxChatModel.Builder)((WatsonxChatModel.Builder)WatsonxChatModel.builder().url(url)).timeout(timeout)).logRequests(logRequests)).logResponses(logResponses)).version(watsonConfig.version())).spaceId(spaceId)).projectId(projectId)).modelId(watsonConfig.chatModel().modelName())).toolChoice(toolChoice).toolChoiceName(toolChoiceName).frequencyPenalty(chatModelConfig.frequencyPenalty()).logprobs(chatModelConfig.logprobs()).topLogprobs(chatModelConfig.topLogprobs().orElse(null)).maxTokens(chatModelConfig.maxTokens()).n(chatModelConfig.n()).presencePenalty(chatModelConfig.presencePenalty()).seed(chatModelConfig.seed().orElse(null)).stop(chatModelConfig.stop().orElse(null)).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).responseFormatText(responseFormat);
    }

    private WatsonxStreamingChatModel.Builder streamingChatBuilder(String configName) {
        String toolChoiceName;
        URL url;
        LangChain4jWatsonxConfig.WatsonConfig defaultConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig();
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonRuntimeConfig(configName);
        List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(configName);
        if (!configProblems.isEmpty()) {
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        ChatModelConfig chatModelConfig = watsonConfig.chatModel();
        try {
            url = URI.create((String)OptionalUtil.firstOrDefault((Object)defaultConfig.baseUrl().orElse(null), (Optional[])new Optional[]{watsonConfig.baseUrl()})).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String responseFormat = null;
        if (chatModelConfig.responseFormat().isPresent()) {
            switch (chatModelConfig.responseFormat().get().toLowerCase()) {
                case "json_object": 
                case "json_schema": 
                case "text": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The value '%s' for the response-format property is not available. Use one of the values: [%s]".formatted(chatModelConfig.responseFormat().get(), "json_object"));
                }
            }
            responseFormat = chatModelConfig.responseFormat().get();
        }
        ToolChoice toolChoice = (toolChoiceName = (String)chatModelConfig.toolChoiceName().orElse(null)) != null ? ToolChoice.REQUIRED : (ToolChoice)chatModelConfig.toolChoice().orElse(null);
        Duration timeout = (Duration)OptionalUtil.firstOrDefault((Object)Duration.ofSeconds(10L), (Optional[])new Optional[]{watsonConfig.timeout(), defaultConfig.timeout()});
        Boolean logRequests = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logRequests().orElse(false), (Optional[])new Optional[]{chatModelConfig.logRequests(), watsonConfig.logRequests()});
        Boolean logResponses = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logResponses().orElse(false), (Optional[])new Optional[]{chatModelConfig.logResponses(), watsonConfig.logResponses()});
        String spaceId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.spaceId().orElse(null), (Optional[])new Optional[]{watsonConfig.spaceId()});
        String projectId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.projectId().orElse(null), (Optional[])new Optional[]{watsonConfig.projectId()});
        return (WatsonxStreamingChatModel.Builder)((WatsonxStreamingChatModel.Builder)((WatsonxStreamingChatModel.Builder)((WatsonxStreamingChatModel.Builder)((WatsonxStreamingChatModel.Builder)((WatsonxStreamingChatModel.Builder)((WatsonxStreamingChatModel.Builder)((WatsonxStreamingChatModel.Builder)((WatsonxStreamingChatModel.Builder)WatsonxStreamingChatModel.builder().url(url)).timeout(timeout)).logRequests(logRequests)).logResponses(logResponses)).version(watsonConfig.version())).spaceId(spaceId)).projectId(projectId)).modelId(watsonConfig.chatModel().modelName())).toolChoice(toolChoice).toolChoiceName(toolChoiceName).frequencyPenalty(chatModelConfig.frequencyPenalty()).logprobs(chatModelConfig.logprobs()).topLogprobs(chatModelConfig.topLogprobs().orElse(null)).maxTokens(chatModelConfig.maxTokens()).n(chatModelConfig.n()).presencePenalty(chatModelConfig.presencePenalty()).seed(chatModelConfig.seed().orElse(null)).stop(chatModelConfig.stop().orElse(null)).temperature(chatModelConfig.temperature()).topP(chatModelConfig.topP()).responseFormatText(responseFormat);
    }

    private WatsonxGenerationModel.Builder generationBuilder(String configName) {
        URL url;
        LangChain4jWatsonxConfig.WatsonConfig defaultConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig();
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonRuntimeConfig(configName);
        List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(configName);
        if (!configProblems.isEmpty()) {
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        GenerationModelConfig generationModelConfig = watsonConfig.generationModel();
        try {
            url = URI.create((String)OptionalUtil.firstOrDefault((Object)defaultConfig.baseUrl().orElse(null), (Optional[])new Optional[]{watsonConfig.baseUrl()})).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Double decayFactor = generationModelConfig.lengthPenalty().decayFactor().orElse(null);
        Integer startIndex = generationModelConfig.lengthPenalty().startIndex().orElse(null);
        String promptJoiner = generationModelConfig.promptJoiner();
        Duration timeout = (Duration)OptionalUtil.firstOrDefault((Object)Duration.ofSeconds(10L), (Optional[])new Optional[]{watsonConfig.timeout(), defaultConfig.timeout()});
        Boolean logRequests = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logRequests().orElse(false), (Optional[])new Optional[]{generationModelConfig.logRequests(), watsonConfig.logRequests()});
        Boolean logResponses = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logResponses().orElse(false), (Optional[])new Optional[]{generationModelConfig.logResponses(), watsonConfig.logResponses()});
        String spaceId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.spaceId().orElse(null), (Optional[])new Optional[]{watsonConfig.spaceId()});
        String projectId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.projectId().orElse(null), (Optional[])new Optional[]{watsonConfig.projectId()});
        return ((WatsonxGenerationModel.Builder)((WatsonxGenerationModel.Builder)((WatsonxGenerationModel.Builder)((WatsonxGenerationModel.Builder)((WatsonxGenerationModel.Builder)((WatsonxGenerationModel.Builder)((WatsonxGenerationModel.Builder)((WatsonxGenerationModel.Builder)WatsonxGenerationModel.builder().url(url)).timeout(timeout)).logRequests(logRequests)).logResponses(logResponses)).version(watsonConfig.version())).spaceId(spaceId)).projectId(projectId)).modelId(watsonConfig.generationModel().modelName())).decodingMethod(generationModelConfig.decodingMethod()).decayFactor(decayFactor).startIndex(startIndex).maxNewTokens(generationModelConfig.maxNewTokens()).minNewTokens(generationModelConfig.minNewTokens()).temperature(generationModelConfig.temperature()).randomSeed(generationModelConfig.randomSeed().orElse(null)).stopSequences(generationModelConfig.stopSequences().orElse(null)).topK(generationModelConfig.topK().orElse(null)).topP(generationModelConfig.topP().orElse(null)).repetitionPenalty(generationModelConfig.repetitionPenalty().orElse(null)).truncateInputTokens(generationModelConfig.truncateInputTokens().orElse(null)).includeStopSequence(generationModelConfig.includeStopSequence().orElse(null)).promptJoiner(promptJoiner);
    }

    private WatsonxGenerationStreamingModel.Builder generationStreamingBuilder(String configName) {
        URL url;
        LangChain4jWatsonxConfig.WatsonConfig defaultConfig = ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig();
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonRuntimeConfig(configName);
        List<ConfigValidationException.Problem> configProblems = this.checkConfigurations(configName);
        if (!configProblems.isEmpty()) {
            throw new ConfigValidationException(configProblems.toArray(EMPTY_PROBLEMS));
        }
        GenerationModelConfig generationModelConfig = watsonConfig.generationModel();
        try {
            url = URI.create((String)OptionalUtil.firstOrDefault((Object)defaultConfig.baseUrl().orElse(null), (Optional[])new Optional[]{watsonConfig.baseUrl()})).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Double decayFactor = generationModelConfig.lengthPenalty().decayFactor().orElse(null);
        Integer startIndex = generationModelConfig.lengthPenalty().startIndex().orElse(null);
        String promptJoiner = generationModelConfig.promptJoiner();
        Duration timeout = (Duration)OptionalUtil.firstOrDefault((Object)Duration.ofSeconds(10L), (Optional[])new Optional[]{watsonConfig.timeout(), defaultConfig.timeout()});
        Boolean logRequests = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logRequests().orElse(false), (Optional[])new Optional[]{generationModelConfig.logRequests(), watsonConfig.logRequests()});
        Boolean logResponses = (Boolean)OptionalUtil.firstOrDefault((Object)defaultConfig.logResponses().orElse(false), (Optional[])new Optional[]{generationModelConfig.logResponses(), watsonConfig.logResponses()});
        String spaceId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.spaceId().orElse(null), (Optional[])new Optional[]{watsonConfig.spaceId()});
        String projectId = (String)OptionalUtil.firstOrDefault((Object)defaultConfig.projectId().orElse(null), (Optional[])new Optional[]{watsonConfig.projectId()});
        return ((WatsonxGenerationStreamingModel.Builder)((WatsonxGenerationStreamingModel.Builder)((WatsonxGenerationStreamingModel.Builder)((WatsonxGenerationStreamingModel.Builder)((WatsonxGenerationStreamingModel.Builder)((WatsonxGenerationStreamingModel.Builder)((WatsonxGenerationStreamingModel.Builder)((WatsonxGenerationStreamingModel.Builder)WatsonxGenerationStreamingModel.builder().url(url)).timeout(timeout)).logRequests(logRequests)).logResponses(logResponses)).version(watsonConfig.version())).spaceId(spaceId)).projectId(projectId)).modelId(watsonConfig.generationModel().modelName())).decodingMethod(generationModelConfig.decodingMethod()).decayFactor(decayFactor).startIndex(startIndex).maxNewTokens(generationModelConfig.maxNewTokens()).minNewTokens(generationModelConfig.minNewTokens()).temperature(generationModelConfig.temperature()).randomSeed(generationModelConfig.randomSeed().orElse(null)).stopSequences(generationModelConfig.stopSequences().orElse(null)).topK(generationModelConfig.topK().orElse(null)).topP(generationModelConfig.topP().orElse(null)).repetitionPenalty(generationModelConfig.repetitionPenalty().orElse(null)).truncateInputTokens(generationModelConfig.truncateInputTokens().orElse(null)).includeStopSequence(generationModelConfig.includeStopSequence().orElse(null)).promptJoiner(promptJoiner);
    }

    private LangChain4jWatsonxConfig.WatsonConfig correspondingWatsonRuntimeConfig(String configName) {
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = NamedConfigUtil.isDefault((String)configName) ? ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig() : ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).namedConfig().get(configName);
        return watsonConfig;
    }

    private List<ConfigValidationException.Problem> checkConfigurations(String configName) {
        ArrayList<ConfigValidationException.Problem> configProblems = new ArrayList<ConfigValidationException.Problem>();
        LangChain4jWatsonxConfig.WatsonConfig watsonConfig = this.correspondingWatsonRuntimeConfig(configName);
        if (watsonConfig.baseUrl().isEmpty() && ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().baseUrl().isEmpty()) {
            configProblems.add(this.createBaseURLConfigProblem(configName));
        }
        if (watsonConfig.apiKey().isEmpty() && ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().apiKey().isEmpty()) {
            configProblems.add(this.createApiKeyConfigProblem(configName));
        }
        if (watsonConfig.projectId().isEmpty() && ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().projectId().isEmpty() && watsonConfig.spaceId().isEmpty() && ((LangChain4jWatsonxConfig)this.runtimeConfig.getValue()).defaultConfig().spaceId().isEmpty()) {
            Object config = NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".";
            String errorMessage = "One of the properties quarkus.langchain4j.watsonx%s%s / quarkus.langchain4j.watsonx%s%s is required, but could not be found in any config source";
            configProblems.add(new ConfigValidationException.Problem(String.format(errorMessage, config, "project-id", config, "space-id")));
        }
        return configProblems;
    }

    private ConfigValidationException.Problem createBaseURLConfigProblem(String configName) {
        return WatsonxRecorder.createConfigProblem("base-url", configName);
    }

    private ConfigValidationException.Problem createApiKeyConfigProblem(String configName) {
        return WatsonxRecorder.createConfigProblem("api-key", configName);
    }

    private static ConfigValidationException.Problem createConfigProblem(String key, String configName) {
        return new ConfigValidationException.Problem(String.format("SRCFG00014: The config property quarkus.langchain4j.watsonx%s%s is required but it could not be found in any config source", NamedConfigUtil.isDefault((String)configName) ? "." : "." + configName + ".", key));
    }
}

