/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.runtime;

import io.quarkiverse.langchain4j.watsonx.bean.IdentityTokenRequest;
import io.quarkiverse.langchain4j.watsonx.bean.IdentityTokenResponse;
import io.quarkiverse.langchain4j.watsonx.client.IAMRestApi;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import io.smallrye.mutiny.Uni;
import java.net.URL;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class TokenGenerator {
    private final Semaphore lock = new Semaphore(1);
    private final IAMRestApi client;
    private final String apiKey;
    private final String grantType;
    private IdentityTokenResponse token;

    public TokenGenerator(URL url, Duration timeout, String grantType, String apiKey) {
        this.client = (IAMRestApi)QuarkusRestClientBuilder.newBuilder().baseUrl(url).connectTimeout(timeout.toSeconds(), TimeUnit.SECONDS).readTimeout(timeout.toSeconds(), TimeUnit.SECONDS).build(IAMRestApi.class);
        this.grantType = grantType;
        this.apiKey = apiKey;
    }

    public Uni<String> generate() {
        try {
            Date now;
            Date expiration;
            this.lock.acquire();
            if (this.token != null && (expiration = new Date(TimeUnit.SECONDS.toMillis(this.token.expiration()))).after(now = new Date())) {
                this.lock.release();
                return Uni.createFrom().item((Object)this.token.accessToken());
            }
            return this.client.generateBearer(new IdentityTokenRequest(this.grantType, this.apiKey)).invoke((Consumer)new Consumer<IdentityTokenResponse>(){

                @Override
                public void accept(IdentityTokenResponse result) {
                    TokenGenerator.this.token = result;
                }
            }).map(IdentityTokenResponse::accessToken).onTermination().invoke(new Runnable(){

                @Override
                public void run() {
                    TokenGenerator.this.lock.release();
                }
            });
        }
        catch (Exception e) {
            this.lock.release();
            throw new RuntimeException(e);
        }
    }
}

