/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.runtime;

import io.quarkiverse.langchain4j.runtime.OptionalUtil;
import io.quarkiverse.langchain4j.watsonx.WatsonxUtils;
import io.quarkiverse.langchain4j.watsonx.bean.TextExtractionRequest;
import io.quarkiverse.langchain4j.watsonx.bean.TextExtractionResponse;
import io.quarkiverse.langchain4j.watsonx.client.COSRestApi;
import io.quarkiverse.langchain4j.watsonx.client.WatsonxRestApi;
import io.quarkiverse.langchain4j.watsonx.exception.COSException;
import io.quarkiverse.langchain4j.watsonx.exception.TextExtractionException;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.logging.Logger;

public class TextExtraction {
    private static final Logger logger = Logger.getLogger(TextExtraction.class);
    private final WatsonxRestApi watsonxClient;
    private final COSRestApi cosClient;
    private final Reference documentReference;
    private final Reference resultReference;
    private final String projectId;
    private final String spaceId;
    private final String version;

    public TextExtraction(Reference documentReference, Reference resultReference, String projectId, String spaceId, String version, COSRestApi cosClient, WatsonxRestApi watsonxClient) {
        Objects.requireNonNull(cosClient);
        Objects.requireNonNull(documentReference);
        Objects.requireNonNull(resultReference);
        Objects.requireNonNull(watsonxClient);
        this.documentReference = documentReference;
        this.resultReference = resultReference;
        this.projectId = projectId;
        this.spaceId = spaceId;
        this.version = version;
        this.cosClient = cosClient;
        this.watsonxClient = watsonxClient;
    }

    public String startExtraction(String absolutePath) throws TextExtractionException {
        return this.startExtraction(absolutePath, Parameters.builder().build());
    }

    public String startExtraction(String absolutePath, Parameters parameters) throws TextExtractionException {
        Objects.requireNonNull(parameters);
        return this.startExtraction(absolutePath, parameters, false).metadata().id();
    }

    public String uploadAndStartExtraction(File file) throws TextExtractionException {
        return this.uploadAndStartExtraction(file, Parameters.builder().build());
    }

    public String uploadAndStartExtraction(File file, Parameters parameters) throws TextExtractionException {
        Objects.requireNonNull(parameters);
        Objects.requireNonNull(file);
        if (file.isDirectory()) {
            throw new TextExtractionException("directory_not_allowed", "The file can not be a directory");
        }
        try {
            this.upload(new BufferedInputStream(new FileInputStream(file)), file.getName(), parameters, false);
            return this.startExtraction(file.getName(), parameters);
        }
        catch (FileNotFoundException e) {
            throw new TextExtractionException("file_not_found", e.getMessage(), e);
        }
    }

    public String uploadAndStartExtraction(InputStream is, String fileName) throws TextExtractionException {
        return this.uploadAndStartExtraction(is, fileName, Parameters.builder().build());
    }

    public String uploadAndStartExtraction(InputStream is, String fileName, Parameters parameters) throws TextExtractionException {
        Objects.requireNonNull(parameters);
        this.upload(is, fileName, parameters, false);
        return this.startExtraction(fileName, parameters);
    }

    public String extractAndFetch(String absolutePath) throws TextExtractionException {
        return this.extractAndFetch(absolutePath, Parameters.builder().build());
    }

    public String extractAndFetch(String absolutePath, Parameters parameters) throws TextExtractionException {
        Objects.requireNonNull(parameters);
        if (parameters.types.size() > 1) {
            throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed if more than one file is to be generated");
        }
        if (parameters.types.size() == 1 && parameters.types.get(0).equals((Object)TextExtractionRequest.Type.PAGE_IMAGES)) {
            throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed for the type \"page_images\"");
        }
        TextExtractionResponse textExtractionResponse = this.startExtraction(absolutePath, parameters, true);
        return this.getExtractedText(textExtractionResponse, parameters);
    }

    public String uploadExtractAndFetch(File file) throws TextExtractionException {
        return this.uploadExtractAndFetch(file, Parameters.builder().build());
    }

    public String uploadExtractAndFetch(File file, Parameters parameters) throws TextExtractionException {
        Objects.requireNonNull(parameters);
        if (parameters.types.size() > 1) {
            throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed if more than one file is to be generated");
        }
        if (parameters.types.size() == 1 && parameters.types.get(0).equals((Object)TextExtractionRequest.Type.PAGE_IMAGES)) {
            throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed for the type \"page_images\"");
        }
        try {
            this.upload(new BufferedInputStream(new FileInputStream(file)), file.getName(), parameters, true);
        }
        catch (FileNotFoundException e) {
            throw new TextExtractionException("file_not_found", e.getMessage(), e);
        }
        return this.extractAndFetch(file.getName(), parameters);
    }

    public String uploadExtractAndFetch(InputStream is, String fileName) throws TextExtractionException {
        return this.uploadExtractAndFetch(is, fileName, Parameters.builder().build());
    }

    public String uploadExtractAndFetch(InputStream is, String fileName, Parameters parameters) throws TextExtractionException {
        Objects.requireNonNull(parameters);
        if (parameters.types.size() > 1) {
            throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed if more than one file is to be generated");
        }
        if (parameters.types.size() == 1 && parameters.types.get(0).equals((Object)TextExtractionRequest.Type.PAGE_IMAGES)) {
            throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed for the type \"page_images\"");
        }
        this.upload(is, fileName, parameters, true);
        return this.extractAndFetch(fileName, parameters);
    }

    public TextExtractionResponse checkExtractionStatus(final String id) throws TextExtractionException {
        return WatsonxUtils.retryOn(new Callable<TextExtractionResponse>(){
            final /* synthetic */ TextExtraction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public TextExtractionResponse call() throws Exception {
                return this.this$0.watsonxClient.getTextExtractionDetails(id, this.this$0.spaceId, this.this$0.projectId, this.this$0.version);
            }
        });
    }

    public void deleteFile(String bucketName, String path) throws COSException {
        this.deleteFile(bucketName, path, Duration.ofMinutes(1L));
    }

    public void deleteFile(String bucketName, String path, Duration timeout) throws COSException {
        Objects.requireNonNull(bucketName);
        Objects.requireNonNull(path);
        timeout = Objects.isNull(timeout) ? Duration.ofMinutes(1L) : timeout;
        this.cosClient.deleteFile(bucketName, path).onFailure(WatsonxUtils::isTokenExpired).retry().atMost(1L).await().atMost(timeout);
    }

    private void upload(final InputStream is, final String fileName, Parameters parameters, boolean waitForExtraction) {
        Objects.requireNonNull(is);
        if (Objects.isNull(fileName) || fileName.isBlank()) {
            throw new IllegalArgumentException("The file name can not be null or empty");
        }
        boolean removeOutputFile = parameters.removeOutputFile.orElse(false);
        boolean removeUploadedFile = parameters.removeUploadedFile.orElse(false);
        if (!waitForExtraction && (removeOutputFile || removeUploadedFile)) {
            throw new IllegalArgumentException("The asynchronous version of startExtraction doesn't allow the use of the \"removeOutputFile\" and \"removeUploadedFile\" parameters");
        }
        final Reference documentReference = (Reference)OptionalUtil.firstOrDefault((Object)this.documentReference, (Optional[])new Optional[]{parameters.documentReference});
        WatsonxUtils.retryOn(new Callable<Response>(){
            final /* synthetic */ TextExtraction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Response call() throws Exception {
                return this.this$0.cosClient.createFile(documentReference.bucket, fileName, is);
            }
        });
    }

    private TextExtractionResponse startExtraction(String absolutePath, Parameters parameters, boolean waitUntilJobIsDone) throws TextExtractionException {
        String processId;
        TextExtractionResponse.Status status;
        Objects.requireNonNull(absolutePath);
        Objects.requireNonNull(parameters);
        boolean removeOutputFile = parameters.removeOutputFile.orElse(false);
        boolean removeUploadedFile = parameters.removeUploadedFile.orElse(false);
        if (!waitUntilJobIsDone && (removeOutputFile || removeUploadedFile)) {
            throw new IllegalArgumentException("The asynchronous version of startExtraction doesn't allow the use of the \"removeOutputFile\" and \"removeUploadedFile\" parameters");
        }
        if (Objects.isNull(parameters.outputFileName) || parameters.outputFileName.isBlank()) {
            if (parameters.types.size() > 1 || parameters.types.size() == 1 && parameters.types.get(0).equals((Object)TextExtractionRequest.Type.PAGE_IMAGES)) {
                parameters.outputFileName = "/";
            } else if (parameters.types.size() == 1) {
                String extension = switch (parameters.types.get(0)) {
                    default -> throw new IncompatibleClassChangeError();
                    case TextExtractionRequest.Type.JSON -> ".json";
                    case TextExtractionRequest.Type.MD -> ".md";
                    case TextExtractionRequest.Type.HTML -> ".html";
                    case TextExtractionRequest.Type.PLAIN_TEXT -> ".txt";
                    case TextExtractionRequest.Type.PAGE_IMAGES -> throw new RuntimeException("If you select \"page_images\" as type, the output file name cannot be null.");
                };
                int index = absolutePath.lastIndexOf(".");
                parameters.outputFileName = index > 0 ? absolutePath.substring(0, index) + extension : absolutePath + extension;
            }
        }
        Reference documentReference = (Reference)OptionalUtil.firstOrDefault((Object)this.documentReference, (Optional[])new Optional[]{parameters.documentReference});
        Reference resultsReference = (Reference)OptionalUtil.firstOrDefault((Object)this.resultReference, (Optional[])new Optional[]{parameters.resultsReference});
        TextExtractionRequest.TextExtractionDataReference textExtractionDataReference = TextExtractionRequest.TextExtractionDataReference.of(documentReference.connection, absolutePath, documentReference.bucket);
        TextExtractionRequest.TextExtractionDataReference textExtractionResultsReference = TextExtractionRequest.TextExtractionDataReference.of(resultsReference.connection, parameters.outputFileName, resultsReference.bucket);
        TextExtractionRequest.TextExtractionParameters textExtractionParameters = new TextExtractionRequest.TextExtractionParameters(parameters.types, parameters.mode, parameters.ocr, parameters.autoRotationCorrection, parameters.embeddedImages, parameters.dpi, parameters.outputTokensAndBbox);
        final TextExtractionRequest request = TextExtractionRequest.builder().documentReference(textExtractionDataReference).resultsReference(textExtractionResultsReference).parameters(textExtractionParameters).projectId(this.projectId).spaceId(this.spaceId).build();
        TextExtractionResponse response = WatsonxUtils.retryOn(new Callable<TextExtractionResponse>(){
            final /* synthetic */ TextExtraction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public TextExtractionResponse call() throws Exception {
                return this.this$0.watsonxClient.startTextExtractionJob(request, this.this$0.version);
            }
        });
        if (!waitUntilJobIsDone) {
            return response;
        }
        long sleepTime = 100L;
        LocalTime endTime = LocalTime.now().plus(parameters.timeout);
        do {
            if (LocalTime.now().isAfter(endTime)) {
                throw new TextExtractionException("timeout", "Execution to extract %s file took longer than the timeout set by %s milliseconds".formatted(absolutePath, parameters.timeout.toMillis()));
            }
            try {
                Thread.sleep(sleepTime);
                sleepTime *= 2L;
                sleepTime = Math.min(sleepTime, 3000L);
            }
            catch (Exception e) {
                throw new TextExtractionException("interrupted", e.getMessage());
            }
        } while ((status = (response = WatsonxUtils.retryOn(new Callable<TextExtractionResponse>(){
            final /* synthetic */ String val$processId;
            final /* synthetic */ TextExtraction this$0;
            {
                this.val$processId = string;
                this.this$0 = this$0;
            }

            @Override
            public TextExtractionResponse call() throws Exception {
                return this.this$0.watsonxClient.getTextExtractionDetails(this.val$processId, this.this$0.spaceId, this.this$0.projectId, this.this$0.version);
            }
        })).entity().results().status()) != TextExtractionResponse.Status.FAILED && status != TextExtractionResponse.Status.COMPLETED);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String getExtractedText(TextExtractionResponse textExtractionResponse, final Parameters parameters) throws TextExtractionException {
        block8: {
            Objects.requireNonNull(textExtractionResponse);
            Objects.requireNonNull(parameters);
            uploadedPath = textExtractionResponse.entity().documentReference().location().fileName();
            outputPath = textExtractionResponse.entity().resultsReference().location().fileName();
            status = textExtractionResponse.entity().results().status();
            removeUploadedFile = parameters.removeUploadedFile.orElse(false);
            removeOutputFile = parameters.removeOutputFile.orElse(false);
            documentReference = (Reference)OptionalUtil.firstOrDefault((Object)this.documentReference, (Optional[])new Optional[]{parameters.documentReference});
            documentBucketName = documentReference.bucket;
            resultsReference = (Reference)OptionalUtil.firstOrDefault((Object)this.resultReference, (Optional[])new Optional[]{parameters.resultsReference});
            resultsBucketName = resultsReference.bucket;
            try {
                switch (8.$SwitchMap$io$quarkiverse$langchain4j$watsonx$bean$TextExtractionResponse$Status[status.ordinal()]) {
                    case 1: {
                        ** break;
                    }
                    case 2: {
                        error = textExtractionResponse.entity().results().error();
                        throw new TextExtractionException(error.code(), error.message());
                    }
                    default: {
                        throw new TextExtractionException("generic_error", "Status %s not managed".formatted(new Object[]{status}));
                    }
lbl-1000:
                    // 1 sources

                    {
                        extractedFile = WatsonxUtils.retryOn(new Callable<String>(){
                            final /* synthetic */ TextExtraction this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public String call() throws Exception {
                                return this.this$0.cosClient.getFileContent(resultsBucketName, parameters.outputFileName);
                            }
                        });
                    }
                }
                if (removeOutputFile) {
                    this.cosClient.deleteFile(resultsBucketName, outputPath).onFailure((Predicate<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isTokenExpired(java.lang.Throwable ), (Ljava/lang/Throwable;)Z)()).retry().atMost(1L).subscribe().with((Consumer)new Consumer<Response>(){
                        final /* synthetic */ TextExtraction this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void accept(Response response) {
                            if (response.getStatus() >= 200 || response.getStatus() < 300) {
                                logger.debug((Object)"File %s deleted from the Cloud Object Storage".formatted(outputPath));
                            } else {
                                logger.error((Object)"Error during the execution of the delete operation for the file %s".formatted(outputPath));
                            }
                        }
                    });
                }
                var13_13 = extractedFile;
                if (!removeUploadedFile) break block8;
            }
            catch (Throwable var14_15) {
                if (removeUploadedFile) {
                    this.cosClient.deleteFile(documentBucketName, uploadedPath).onFailure((Predicate<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isTokenExpired(java.lang.Throwable ), (Ljava/lang/Throwable;)Z)()).retry().atMost(1L).subscribe().with((Consumer)new Consumer<Response>(){
                        final /* synthetic */ String val$uploadedPath;
                        final /* synthetic */ TextExtraction this$0;
                        {
                            this.val$uploadedPath = string;
                            this.this$0 = this$0;
                        }

                        @Override
                        public void accept(Response response) {
                            if (response.getStatus() >= 200 || response.getStatus() < 300) {
                                logger.debug((Object)"File %s deleted from the Cloud Object Storage".formatted(this.val$uploadedPath));
                            } else {
                                logger.error((Object)"Error during the execution of the delete operation for the file %s".formatted(this.val$uploadedPath));
                            }
                        }
                    });
                }
                throw var14_15;
            }
            this.cosClient.deleteFile(documentBucketName, uploadedPath).onFailure((Predicate<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isTokenExpired(java.lang.Throwable ), (Ljava/lang/Throwable;)Z)()).retry().atMost(1L).subscribe().with((Consumer)new /* invalid duplicate definition of identical inner class */);
        }
        return var13_13;
    }

    public record Reference(String connection, String bucket) {
        public Reference {
            Objects.requireNonNull(connection);
        }

        public Reference(String connection) {
            this(connection, null);
        }
    }

    public static class Parameters {
        final Duration timeout;
        String outputFileName;
        final List<TextExtractionRequest.Type> types;
        final Optional<Reference> documentReference;
        final Optional<Reference> resultsReference;
        final Optional<Boolean> removeUploadedFile;
        final Optional<Boolean> removeOutputFile;
        final TextExtractionRequest.Mode mode;
        final TextExtractionRequest.OCR ocr;
        final Boolean autoRotationCorrection;
        final TextExtractionRequest.EmbeddedImages embeddedImages;
        final Integer dpi;
        final Boolean outputTokensAndBbox;

        protected Parameters(Builder builder) {
            this.timeout = Objects.isNull(builder.timeout) ? Duration.ofSeconds(60L) : builder.timeout;
            this.outputFileName = builder.outputFileName;
            this.types = Objects.isNull(builder.types) ? List.of(TextExtractionRequest.Type.MD) : builder.types;
            this.documentReference = Objects.isNull(builder.documentReference) ? Optional.empty() : builder.documentReference;
            this.resultsReference = Objects.isNull(builder.resultsReference) ? Optional.empty() : builder.resultsReference;
            this.removeUploadedFile = Objects.isNull(builder.removeUploadedFile) ? Optional.empty() : builder.removeUploadedFile;
            this.removeOutputFile = Objects.isNull(builder.removeOutputFile) ? Optional.empty() : builder.removeOutputFile;
            this.mode = builder.mode;
            this.ocr = builder.ocr;
            this.autoRotationCorrection = builder.autoRotationCorrection;
            this.embeddedImages = builder.embeddedImages;
            this.dpi = builder.dpi;
            this.outputTokensAndBbox = builder.outputTokensAndBbox;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public String getOutputFileName() {
            return this.outputFileName;
        }

        public List<TextExtractionRequest.Type> getTypes() {
            return this.types;
        }

        public Optional<Reference> getDocumentReference() {
            return this.documentReference;
        }

        public Optional<Reference> getResultsReference() {
            return this.resultsReference;
        }

        public Optional<Boolean> getRemoveUploadedFile() {
            return this.removeUploadedFile;
        }

        public Optional<Boolean> getRemoveOutputFile() {
            return this.removeOutputFile;
        }

        public TextExtractionRequest.Mode getMode() {
            return this.mode;
        }

        public TextExtractionRequest.OCR getOcr() {
            return this.ocr;
        }

        public Boolean getAutoRotationCorrection() {
            return this.autoRotationCorrection;
        }

        public TextExtractionRequest.EmbeddedImages getEmbeddedImages() {
            return this.embeddedImages;
        }

        public Integer getDpi() {
            return this.dpi;
        }

        public Boolean getOutputTokensAndBbox() {
            return this.outputTokensAndBbox;
        }

        public static class Builder {
            private Duration timeout;
            private String outputFileName;
            private List<TextExtractionRequest.Type> types;
            private Optional<Reference> documentReference;
            private Optional<Reference> resultsReference;
            private Optional<Boolean> removeUploadedFile;
            private Optional<Boolean> removeOutputFile;
            private TextExtractionRequest.Mode mode;
            private TextExtractionRequest.OCR ocr;
            private Boolean autoRotationCorrection;
            private TextExtractionRequest.EmbeddedImages embeddedImages;
            private Integer dpi;
            private Boolean outputTokensAndBbox;

            public Builder timeout(Duration timeout) {
                this.timeout = timeout;
                return this;
            }

            public Builder outputFileName(String outputFileName) {
                this.outputFileName = outputFileName;
                return this;
            }

            public Builder types(List<TextExtractionRequest.Type> types) {
                this.types = types;
                return this;
            }

            public Builder types(TextExtractionRequest.Type type) {
                this.types = List.of(type);
                return this;
            }

            public Builder types(TextExtractionRequest.Type ... types) {
                this.types = Arrays.asList(types);
                return this;
            }

            public Builder documentReference(Reference reference) {
                this.documentReference = Optional.ofNullable(reference);
                return this;
            }

            public Builder resultsReference(Reference reference) {
                this.resultsReference = Optional.ofNullable(reference);
                return this;
            }

            public Builder removeUploadedFile(Boolean removeUploadedFile) {
                this.removeUploadedFile = Optional.ofNullable(removeUploadedFile);
                return this;
            }

            public Builder removeOutputFile(Boolean removeOutputFile) {
                this.removeOutputFile = Optional.ofNullable(removeOutputFile);
                return this;
            }

            public Builder mode(TextExtractionRequest.Mode mode) {
                this.mode = mode;
                return this;
            }

            public Builder ocr(TextExtractionRequest.OCR ocr) {
                this.ocr = ocr;
                return this;
            }

            public Builder autoRotationCorrection(Boolean autoRotationCorrection) {
                this.autoRotationCorrection = autoRotationCorrection;
                return this;
            }

            public Builder embeddedImages(TextExtractionRequest.EmbeddedImages embeddedImages) {
                this.embeddedImages = embeddedImages;
                return this;
            }

            public Builder dpi(Integer dpi) {
                this.dpi = dpi;
                return this;
            }

            public Builder outputTokensAndBbox(Boolean outputTokensAndBbox) {
                this.outputTokensAndBbox = outputTokensAndBbox;
                return this;
            }

            public Parameters build() {
                return new Parameters(this);
            }
        }
    }
}

