/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.client;

import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientLogger;

public class WatsonxClientLogger
implements ClientLogger {
    private static final Logger log = Logger.getLogger(WatsonxClientLogger.class);
    private static final Pattern BEARER_PATTERN = Pattern.compile("(Bearer\\s*)(\\w{4})(\\w+)(\\w{4})");
    private static final Pattern BASE64_IMAGE_PATTERN = Pattern.compile("(data:.+;base64,)(.{15})(.+)(.{15})([\\s\\S]*)");
    private final boolean logRequests;
    private final boolean logResponses;

    public WatsonxClientLogger(boolean logRequests, boolean logResponses) {
        this.logRequests = logRequests;
        this.logResponses = logResponses;
    }

    public WatsonxClientLogger(Optional<Boolean> logRequests, Optional<Boolean> logResponses) {
        this.logRequests = logRequests.orElse(false);
        this.logResponses = logResponses.orElse(false);
    }

    public void setBodySize(int bodySize) {
    }

    public void logRequest(HttpClientRequest request, Buffer body, boolean omitBody) {
        if (!this.logRequests || !log.isInfoEnabled()) {
            return;
        }
        try {
            log.infof("Request:\n- method: %s\n- url: %s\n- headers: %s\n- body: %s", new Object[]{request.getMethod(), request.absoluteURI(), this.inOneLine(request.headers()), this.bodyToString(body)});
        }
        catch (Exception e) {
            log.warn((Object)"Failed to log request", (Throwable)e);
        }
    }

    public void logResponse(final HttpClientResponse response, boolean redirect) {
        if (!this.logResponses || !log.isInfoEnabled()) {
            return;
        }
        response.bodyHandler((Handler)new Handler<Buffer>(this){
            final /* synthetic */ WatsonxClientLogger this$0;
            {
                this.this$0 = this$0;
            }

            public void handle(Buffer body) {
                String prettyBody;
                try {
                    prettyBody = QuarkusJsonCodecFactory.ObjectMapperHolder.WRITER.writeValueAsString((Object)QuarkusJsonCodecFactory.ObjectMapperHolder.MAPPER.readTree(this.this$0.bodyToString(body)));
                }
                catch (Exception e) {
                    prettyBody = this.this$0.bodyToString(body);
                }
                try {
                    log.infof("Response:\n- status code: %s\n- headers: %s\n- body: %s", (Object)response.statusCode(), (Object)this.this$0.inOneLine(response.headers()), (Object)prettyBody);
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to log response", (Throwable)e);
                }
            }
        });
    }

    private String bodyToString(Buffer body) {
        if (body == null) {
            return "";
        }
        return WatsonxClientLogger.formatBase64ImageForLogging(body.toString());
    }

    private String inOneLine(MultiMap headers) {
        return StreamSupport.stream(headers.spliterator(), false).map(header -> {
            String headerKey = (String)header.getKey();
            String headerValue = (String)header.getValue();
            if ("Authorization".equals(headerKey)) {
                headerValue = WatsonxClientLogger.maskAuthorizationHeaderValue(headerValue);
            } else if ("api-key".equals(headerKey)) {
                headerValue = WatsonxClientLogger.maskApiKeyHeaderValue(headerValue);
            }
            return String.format("[%s: %s]", headerKey, headerValue);
        }).collect(Collectors.joining(", "));
    }

    private static String maskAuthorizationHeaderValue(String authorizationHeaderValue) {
        try {
            Matcher matcher = BEARER_PATTERN.matcher(authorizationHeaderValue);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                matcher.appendReplacement(sb, matcher.group(1) + matcher.group(2) + "..." + matcher.group(4));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "Failed to mask the API key.";
        }
    }

    private static String formatBase64ImageForLogging(String body) {
        try {
            if (body == null || body.isBlank()) {
                return body;
            }
            Matcher matcher = BASE64_IMAGE_PATTERN.matcher(body);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                matcher.appendReplacement(sb, matcher.group(1) + matcher.group(2) + "..." + matcher.group(4) + matcher.group(5));
            }
            return sb.isEmpty() ? body : sb.toString();
        }
        catch (Exception e) {
            return "Failed to format the base64 image value.";
        }
    }

    private static String maskApiKeyHeaderValue(String apiKeyHeaderValue) {
        try {
            if (apiKeyHeaderValue.length() <= 4) {
                return apiKeyHeaderValue;
            }
            return apiKeyHeaderValue.substring(0, 2) + "..." + apiKeyHeaderValue.substring(apiKeyHeaderValue.length() - 2);
        }
        catch (Exception e) {
            return "Failed to mask the API key.";
        }
    }
}

