/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.langchain4j.Experimental;
import io.quarkiverse.langchain4j.QuarkusJsonCodecFactory;
import io.quarkiverse.langchain4j.watsonx.bean.UtilityAgentToolsRequest;
import io.quarkiverse.langchain4j.watsonx.bean.UtilityAgentToolsResponse;
import io.quarkiverse.langchain4j.watsonx.exception.BuiltinServiceException;
import io.quarkus.rest.client.reactive.ClientExceptionMapper;
import io.quarkus.rest.client.reactive.jackson.ClientObjectMapper;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

@Experimental
@Path(value="/v1-beta/utility_agent_tools")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface UtilityAgentToolsRestApi {
    @POST
    @Path(value="run")
    public UtilityAgentToolsResponse run(UtilityAgentToolsRequest var1);

    @ClientObjectMapper
    public static ObjectMapper objectMapper(ObjectMapper defaultObjectMapper) {
        return QuarkusJsonCodecFactory.SnakeCaseObjectMapperHolder.MAPPER;
    }

    @ClientExceptionMapper
    public static BuiltinServiceException toException(Response response) {
        MediaType mediaType = response.getMediaType();
        if (mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE) && response.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            ObjectNode jsonObject = (ObjectNode)response.readEntity(ObjectNode.class);
            try {
                String description = jsonObject.get("description").asText();
                return new BuiltinServiceException(description, response.getStatus());
            }
            catch (Exception e) {
                return new BuiltinServiceException((String)response.readEntity(String.class), response.getStatus());
            }
        }
        return new BuiltinServiceException((String)response.readEntity(String.class), response.getStatus());
    }
}

