/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.bean;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.List;

public record TextExtractionRequest(String spaceId, String projectId, TextExtractionDataReference documentReference, TextExtractionDataReference resultsReference, TextExtractionParameters parameters) {
    public static Builder builder() {
        return new Builder();
    }

    public record TextExtractionDataReference(String type, CosDataConnection connection, CosDataLocation location) {
        public static TextExtractionDataReference of(String connectionId, String fileName) {
            return new TextExtractionDataReference("connection_asset", new CosDataConnection(connectionId), new CosDataLocation(fileName, null));
        }

        public static TextExtractionDataReference of(String connectionId, String fileName, String bucket) {
            return new TextExtractionDataReference("connection_asset", new CosDataConnection(connectionId), new CosDataLocation(fileName, bucket));
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public record TextExtractionParameters(List<Type> requestedOutputs, Mode mode, OCR ocrMode, Boolean autoRotationCorrection, EmbeddedImages createEmbeddedImages, Integer outputDpi, Boolean outputTokensAndBbox) {
    }

    public static class Builder {
        private String spaceId;
        private String projectId;
        private TextExtractionDataReference documentReference;
        private TextExtractionDataReference resultsReference;
        private TextExtractionParameters parameters;

        public Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder documentReference(TextExtractionDataReference documentReference) {
            this.documentReference = documentReference;
            return this;
        }

        public Builder resultsReference(TextExtractionDataReference resultsReference) {
            this.resultsReference = resultsReference;
            return this;
        }

        public Builder parameters(TextExtractionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public TextExtractionRequest build() {
            return new TextExtractionRequest(this.spaceId, this.projectId, this.documentReference, this.resultsReference, this.parameters);
        }
    }

    public static enum EmbeddedImages {
        DISABLED,
        ENABLED_PLACEHOLDER,
        ENABLED_TEXT,
        ENABLED_VERBALIZATION,
        ENABLED_VERBALIZATION_ALL;

    }

    public static enum OCR {
        DISABLED,
        ENABLED,
        FORCED;

    }

    public static enum Mode {
        STANDARD,
        HIGH_QUALITY;

    }

    public static enum Type {
        JSON,
        HTML,
        MD,
        PLAIN_TEXT,
        PAGE_IMAGES;

    }

    public record CosDataConnection(String id) {
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public record CosDataLocation(String fileName, String bucket) {
    }
}

