/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx.bean;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import io.quarkiverse.langchain4j.watsonx.WatsonxUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TextChatMessage {
    public static TextChatMessage convert(ChatMessage chatMessage) {
        return switch (chatMessage.type()) {
            case ChatMessageType.AI -> TextChatMessageAssistant.of((AiMessage)AiMessage.class.cast(chatMessage));
            case ChatMessageType.SYSTEM -> TextChatMessageSystem.of((SystemMessage)SystemMessage.class.cast(chatMessage));
            case ChatMessageType.USER -> TextChatMessageUser.of((UserMessage)UserMessage.class.cast(chatMessage));
            case ChatMessageType.TOOL_EXECUTION_RESULT -> TextChatMessageTool.of((ToolExecutionResultMessage)ToolExecutionResultMessage.class.cast(chatMessage));
            default -> throw new IllegalArgumentException("Unsupported chat message type: " + String.valueOf(chatMessage.type()));
        };
    }

    public record TextChatMessageAssistant(String role, String content, List<TextChatToolCall> toolCalls) implements TextChatMessage
    {
        private static final String ROLE = "assistant";

        public static TextChatMessageAssistant of(AiMessage aiMessage) {
            if (!aiMessage.hasToolExecutionRequests()) {
                return new TextChatMessageAssistant(ROLE, aiMessage.text(), null);
            }
            List<TextChatToolCall> toolCalls = aiMessage.toolExecutionRequests().stream().map(TextChatToolCall::of).toList();
            return new TextChatMessageAssistant(ROLE, aiMessage.text(), toolCalls);
        }

        public static TextChatMessageAssistant of(String message) {
            return new TextChatMessageAssistant(ROLE, message, null);
        }

        public static TextChatMessageAssistant of(List<TextChatToolCall> toolCalls) {
            return new TextChatMessageAssistant(ROLE, null, toolCalls);
        }
    }

    public record TextChatMessageSystem(String role, String content) implements TextChatMessage
    {
        private static final String ROLE = "system";

        public static TextChatMessageSystem of(SystemMessage systemMessage) {
            return new TextChatMessageSystem(ROLE, systemMessage.text());
        }

        public static TextChatMessageSystem of(String message) {
            return new TextChatMessageSystem(ROLE, message);
        }
    }

    public record TextChatMessageUser(String role, List<Map<String, Object>> content, String name) implements TextChatMessage
    {
        private static final String ROLE = "user";

        public static TextChatMessageUser of(UserMessage userMessage) {
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
            for (Content content : userMessage.contents()) {
                switch (content.type()) {
                    case TEXT: {
                        TextContent textContent = (TextContent)TextContent.class.cast(content);
                        values.add(Map.of("type", "text", "text", textContent.text()));
                        break;
                    }
                    case IMAGE: {
                        ImageContent imageContent = (ImageContent)ImageContent.class.cast(content);
                        String mimeType = imageContent.image().mimeType();
                        String base64 = "data:%s;base64,%s".formatted(Objects.isNull(mimeType) ? "image" : mimeType, WatsonxUtils.base64Image(imageContent.image()));
                        values.add(Map.of("type", "image_url", "image_url", Map.of("url", base64, "detail", imageContent.detailLevel().name().toLowerCase())));
                        break;
                    }
                    case AUDIO: 
                    case PDF: 
                    case VIDEO: {
                        throw new UnsupportedOperationException("Unimplemented case: " + String.valueOf(content.type()));
                    }
                }
            }
            return new TextChatMessageUser(ROLE, values, userMessage.name());
        }

        public static TextChatMessageUser of(String message) {
            return TextChatMessageUser.of(UserMessage.from((String)message));
        }
    }

    public record TextChatMessageTool(String role, String content, String toolCallId) implements TextChatMessage
    {
        private static final String ROLE = "tool";

        public static TextChatMessageTool of(ToolExecutionResultMessage toolExecutionResultMessage) {
            return new TextChatMessageTool(ROLE, toolExecutionResultMessage.text(), toolExecutionResultMessage.id());
        }

        public static TextChatMessageTool of(String content, String toolCallId) {
            return new TextChatMessageTool(ROLE, content, toolCallId);
        }
    }

    public static class StreamingToolFetcher {
        private int index;
        private StringBuilder arguments;
        private String id;
        private String type;
        private String name;

        public StreamingToolFetcher(int index) {
            this.index = index;
            this.arguments = new StringBuilder();
        }

        public void setId(String id) {
            if (id != null) {
                this.id = id;
            }
        }

        public void setType(String type) {
            if (type != null) {
                this.type = type;
            }
        }

        public void setName(String name) {
            if (name != null && !name.isBlank()) {
                this.name = name;
            }
        }

        public void appendArguments(String arguments) {
            if (arguments != null) {
                this.arguments.append(arguments);
            }
        }

        public TextChatToolCall build() {
            if (Objects.isNull(this.id)) {
                this.id = UUID.randomUUID().toString();
            }
            return new TextChatToolCall(this.index, this.id, this.type, new TextChatToolCall.TextChatFunctionCall(this.name, this.arguments.toString()));
        }
    }

    public record TextChatParameterTool(String type, TextChatParameterFunction function) {
        public static TextChatParameterTool of(ToolSpecification toolSpecification) {
            Map toolParams = toolSpecification.parameters() != null ? JsonSchemaElementUtils.toMap((JsonSchemaElement)toolSpecification.parameters()) : null;
            TextChatParameterFunction parameters = new TextChatParameterFunction(toolSpecification.name(), toolSpecification.description(), toolParams);
            return new TextChatParameterTool("function", parameters);
        }

        public record TextChatParameterFunction(String name, String description, Map<String, Object> parameters) {
        }
    }

    public record TextChatToolCall(Integer index, String id, String type, TextChatFunctionCall function) {
        public static TextChatToolCall of(ToolExecutionRequest toolExecutionRequest) {
            return new TextChatToolCall(null, toolExecutionRequest.id(), "function", new TextChatFunctionCall(toolExecutionRequest.name(), toolExecutionRequest.arguments()));
        }

        public ToolExecutionRequest convert() {
            return ToolExecutionRequest.builder().id(this.id).name(this.function.name).arguments(this.function.arguments).build();
        }

        public record TextChatFunctionCall(String name, String arguments) {
        }
    }
}

