/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.scoring.ScoringModel;
import io.quarkiverse.langchain4j.watsonx.Watsonx;
import io.quarkiverse.langchain4j.watsonx.WatsonxUtils;
import io.quarkiverse.langchain4j.watsonx.bean.ScoringParameters;
import io.quarkiverse.langchain4j.watsonx.bean.ScoringRequest;
import io.quarkiverse.langchain4j.watsonx.bean.ScoringResponse;
import io.quarkiverse.langchain4j.watsonx.exception.WatsonxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;

public class WatsonxScoringModel
extends Watsonx
implements ScoringModel {
    private final ScoringParameters parameters;

    public WatsonxScoringModel(Builder builder) {
        super(builder);
        this.parameters = builder.truncateInputTokens != null ? new ScoringParameters(builder.truncateInputTokens) : null;
    }

    public Response<List<Double>> scoreAll(List<TextSegment> textSegments, String query) {
        if (Objects.isNull(query) || query.isEmpty()) {
            throw new WatsonxException("The field \"query\" can not be null or empty", (Integer)400);
        }
        if (Objects.isNull(textSegments) || textSegments.isEmpty()) {
            return Response.from(List.of());
        }
        final ScoringRequest request = ScoringRequest.of(this.modelId, this.spaceId, this.projectId, query, textSegments, this.parameters);
        ScoringResponse response = WatsonxUtils.retryOn(new Callable<ScoringResponse>(){
            final /* synthetic */ WatsonxScoringModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ScoringResponse call() throws Exception {
                return this.this$0.client.rerank(request, this.this$0.version);
            }
        });
        Double[] content = new Double[response.results().size()];
        for (ScoringResponse.ScoringOutput rerankScore : response.results()) {
            content[rerankScore.index().intValue()] = rerankScore.score();
        }
        return Response.from(Arrays.asList(content), (TokenUsage)new TokenUsage(response.inputTokenCount()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Watsonx.Builder<Builder> {
        private Integer truncateInputTokens;

        public Builder truncateInputTokens(Integer truncateInputTokens) {
            this.truncateInputTokens = truncateInputTokens;
            return this;
        }

        public WatsonxScoringModel build() {
            return new WatsonxScoringModel(this);
        }
    }
}

