/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import io.quarkiverse.langchain4j.watsonx.Watsonx;
import io.quarkiverse.langchain4j.watsonx.WatsonxUtils;
import io.quarkiverse.langchain4j.watsonx.bean.EmbeddingParameters;
import io.quarkiverse.langchain4j.watsonx.bean.EmbeddingRequest;
import io.quarkiverse.langchain4j.watsonx.bean.EmbeddingResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class WatsonxEmbeddingModel
extends Watsonx
implements EmbeddingModel {
    private final EmbeddingParameters parameters;
    private static final int MAX_SIZE = 1000;

    public WatsonxEmbeddingModel(Builder builder) {
        super(builder);
        this.parameters = builder.truncateInputTokens != null ? new EmbeddingParameters(builder.truncateInputTokens) : null;
    }

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        if (Objects.isNull(textSegments) || textSegments.isEmpty()) {
            return Response.from(List.of());
        }
        ArrayList<Embedding> result = new ArrayList<Embedding>();
        for (int fromIndex = 0; fromIndex < textSegments.size(); fromIndex += 1000) {
            int toIndex = Math.min(fromIndex + 1000, textSegments.size());
            List<String> subList = textSegments.subList(fromIndex, toIndex).stream().map(TextSegment::text).collect(Collectors.toList());
            final EmbeddingRequest request = new EmbeddingRequest(this.modelId, this.spaceId, this.projectId, subList, this.parameters);
            EmbeddingResponse embeddingResponse = WatsonxUtils.retryOn(new Callable<EmbeddingResponse>(){
                final /* synthetic */ WatsonxEmbeddingModel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public EmbeddingResponse call() throws Exception {
                    return this.this$0.client.embeddings(request, this.this$0.version);
                }
            });
            result.addAll(embeddingResponse.results().stream().map(EmbeddingResponse.Result::embedding).map(Embedding::from).toList());
        }
        return Response.from(result);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Watsonx.Builder<Builder> {
        private Integer truncateInputTokens;

        public Builder truncateInputTokens(Integer truncateInputTokens) {
            this.truncateInputTokens = truncateInputTokens;
            return this;
        }

        public WatsonxEmbeddingModel build() {
            return new WatsonxEmbeddingModel(this);
        }
    }
}

