/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import io.quarkiverse.langchain4j.auth.ModelAuthProvider;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.URI;

public class OllamaModelAuthProviderFilter
implements ClientRequestFilter {
    private final ModelAuthProvider authorizer;

    public OllamaModelAuthProviderFilter(ModelAuthProvider authorizer) {
        this.authorizer = authorizer;
    }

    public void filter(ClientRequestContext context) {
        String authValue = this.authorizer.getAuthorization((ModelAuthProvider.Input)new AuthInputImpl(context.getMethod(), context.getUri(), (MultivaluedMap<String, Object>)context.getHeaders()));
        if (authValue != null) {
            context.getHeaders().putSingle((Object)"Authorization", (Object)authValue);
        }
    }

    private static final class AuthInputImpl
    extends Record
    implements ModelAuthProvider.Input {
        private final String method;
        private final URI uri;
        private final MultivaluedMap<String, Object> headers;

        private AuthInputImpl(String method, URI uri, MultivaluedMap<String, Object> headers) {
            this.method = method;
            this.uri = uri;
            this.headers = headers;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AuthInputImpl.class, "method;uri;headers", "method", "uri", "headers"}, this, o);
        }

        public String method() {
            return this.method;
        }

        public URI uri() {
            return this.uri;
        }

        public MultivaluedMap<String, Object> headers() {
            return this.headers;
        }
    }
}

