/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.jaxrsclient;

import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import io.quarkiverse.langchain4j.jaxrsclient.JaxRsHttpClient;
import io.quarkus.tls.TlsConfiguration;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class JaxRsHttpClientBuilder
implements HttpClientBuilder {
    private Duration connectTimeout;
    private Duration readTimeout;
    private final List<Object> clientProviders = new ArrayList<Object>();
    private TlsConfiguration tlsConfiguration;

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public HttpClientBuilder connectTimeout(Duration timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public Duration readTimeout() {
        return this.readTimeout;
    }

    public HttpClientBuilder readTimeout(Duration timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public HttpClientBuilder addClientProvider(Object clientProvider) {
        this.clientProviders.add(clientProvider);
        return this;
    }

    public JaxRsHttpClientBuilder tlsConfiguration(TlsConfiguration tlsConfiguration) {
        this.tlsConfiguration = tlsConfiguration;
        return this;
    }

    public List<Object> clientProviders() {
        return this.clientProviders;
    }

    public TlsConfiguration tlsConfiguration() {
        return this.tlsConfiguration;
    }

    public HttpClient build() {
        return new JaxRsHttpClient(this);
    }
}

