/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFServletInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class CXFServletInfos {
    private final List<CXFServletInfo> infos;
    private static final Logger LOGGER = Logger.getLogger(CXFServletInfos.class);
    private final String path;
    private final String contextPath;

    public CXFServletInfos(String path, String contextPath) {
        LOGGER.trace((Object)"new CXFServletInfos");
        this.path = path;
        this.contextPath = contextPath;
        this.infos = new ArrayList<CXFServletInfo>();
    }

    public Collection<CXFServletInfo> getInfos() {
        return this.infos;
    }

    public String getPath() {
        return this.path;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public List<String> getWrappersclasses() {
        if (this.infos == null) {
            return Collections.emptyList();
        }
        return this.infos.stream().map(CXFServletInfo::getWrapperClassNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void add(CXFServletInfo cfg) {
        this.infos.add(cfg);
    }
}

