/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.ws.security.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.wss4j.common.cache.EHCacheValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class EhcacheProcessor {
    @BuildStep
    void indexDependencies(BuildProducer<IndexDependencyBuildItem> indexDependencies) {
        Stream.of("org.ehcache:ehcache:jakarta").forEach(ga -> {
            String[] coords = ga.split(":");
            indexDependencies.produce((BuildItem)new IndexDependencyBuildItem(coords[0], coords[1], coords[2]));
        });
    }

    @BuildStep
    void registerServices(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        Stream.of("org.ehcache.core.spi.service.ServiceFactory", "org.ehcache.core.spi.service.StatisticsService", "org.ehcache.xml.CacheManagerServiceConfigurationParser", "org.ehcache.xml.CacheServiceConfigurationParser").forEach(serviceName -> {
            try {
                Set names = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + serviceName));
                serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(serviceName, new ArrayList(names)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @BuildStep
    void reflectiveClass(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = combinedIndexBuildItem.getIndex();
        Stream.of("org.ehcache.spi.copy.Copier", "org.ehcache.spi.resilience.ResilienceStrategy", "org.ehcache.spi.serialization.Serializer").map(DotName::createSimple).flatMap(dotName -> index.getAllKnownImplementors(dotName).stream()).map(classInfo -> classInfo.name().toString()).map(className -> ReflectiveClassBuildItem.builder((String[])new String[]{className}).build()).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        Stream.of("org.ehcache.shadow.org.terracotta.statistics.SourceStatistic").map(DotName::createSimple).flatMap(dotName -> index.getAllKnownImplementors(dotName).stream()).map(classInfo -> classInfo.name().toString()).map(className -> ReflectiveClassBuildItem.builder((String[])new String[]{className}).fields().build()).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        Stream.of("org.ehcache.shadow.org.terracotta.context.query.Matcher").map(DotName::createSimple).flatMap(dotName -> index.getAllKnownSubclasses(dotName).stream()).map(classInfo -> classInfo.name().toString()).map(className -> ReflectiveClassBuildItem.builder((String[])new String[]{className}).methods().build()).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        Stream.of(EHCacheValue.class.getName(), String.class.getName(), Instant.class.getName(), "java.time.Ser").map(className -> ReflectiveClassBuildItem.builder((String[])new String[]{className}).serialization().build()).forEach(arg_0 -> reflectiveClass.produce(arg_0));
    }

    @BuildStep
    void proxyItems(BuildProducer<NativeImageProxyDefinitionBuildItem> proxies) {
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.ehcache.shadow.org.terracotta.offheapstore.storage.portability.Portability", "org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent.PersistentPortability"}));
        proxies.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.ehcache.shadow.org.terracotta.offheapstore.storage.portability.WriteBackPortability", "org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent.PersistentPortability"}));
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResource() {
        return new NativeImageResourceBuildItem(new String[]{"cxf-ehcache.xml", "ehcache-107-ext.xsd", "ehcache-core.xsd"});
    }

    @BuildStep
    void nativeImageSystemProperties(BuildProducer<NativeImageSystemPropertyBuildItem> nativeImageSystemProperties) {
        nativeImageSystemProperties.produce((BuildItem)new NativeImageSystemPropertyBuildItem("org.ehcache.sizeof.AgentSizeOf.bypass", "true"));
    }

    @BuildStep
    void runtimeInitializedClass(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        Stream.of("org.ehcache.sizeof.impl.JvmInformation", "org.ehcache.shadow.org.terracotta.utilities.io.Files", "org.ehcache.shadow.org.terracotta.offheapstore.storage.portability.BooleanPortability", "org.ehcache.shadow.org.terracotta.offheapstore.util.PhysicalMemory", "org.ehcache.xml.XmlConfiguration", "org.ehcache.xml.ResourceConfigurationParser").map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClass.produce(arg_0));
    }
}

