/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import io.qameta.allure.maven.AllureCommandline;
import io.qameta.allure.maven.ProxyUtils;
import java.nio.file.Paths;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="install", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class AllureInstallMojo
extends AbstractMojo {
    @Parameter(property="report.version")
    private String reportVersion;
    @Parameter(property="allure.download.url", defaultValue="https://dl.bintray.com/qameta/generic/io/qameta/allure/allure/%s/allure-%s.zip")
    private String allureDownloadUrl;
    @Parameter(property="allure.install.directory", defaultValue="${project.basedir}/.allure")
    private String installDirectory;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)String.format("Allure installation directory %s", this.installDirectory));
            this.getLog().info((CharSequence)String.format("Try to finding out allure %s", this.reportVersion != null ? this.reportVersion : "2.0.1"));
            AllureCommandline commandline = new AllureCommandline(Paths.get(this.installDirectory, new String[0]), this.reportVersion);
            if (commandline.allureNotExists()) {
                this.getLog().info((CharSequence)"Downloading allure commandline...");
                commandline.download(this.allureDownloadUrl, ProxyUtils.getProxy(this.session, this.decrypter));
                this.getLog().info((CharSequence)"Downloading allure commandline complete");
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Can't install allure", (Throwable)e);
            throw new MojoExecutionException("Can't install allure", e);
        }
    }
}

